/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.spring.boot;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.sharding.algorithm.config.AlgorithmProvidedShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.sharding.spring.boot.algorithm.KeyGenerateAlgorithmProvidedBeanRegistry;
import org.apache.shardingsphere.sharding.spring.boot.algorithm.ShardingAlgorithmProvidedBeanRegistry;
import org.apache.shardingsphere.sharding.spring.boot.condition.ShardingSpringBootCondition;
import org.apache.shardingsphere.sharding.spring.boot.rule.YamlShardingRuleSpringBootConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.ShardingRuleAlgorithmProviderConfigurationYamlSwapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={YamlShardingRuleSpringBootConfiguration.class})
@ConditionalOnClass(value={YamlShardingRuleConfiguration.class})
@Conditional(value={ShardingSpringBootCondition.class})
public class ShardingRuleSpringBootConfiguration {
    private final ShardingRuleAlgorithmProviderConfigurationYamlSwapper swapper = new ShardingRuleAlgorithmProviderConfigurationYamlSwapper();
    private final YamlShardingRuleSpringBootConfiguration yamlConfig;

    @Bean
    public RuleConfiguration shardingRuleConfiguration(ObjectProvider<Map<String, ShardingAlgorithm>> shardingAlgorithmProvider, ObjectProvider<Map<String, KeyGenerateAlgorithm>> keyGenerateAlgorithmProvider) {
        Map shardingAlgorithmMap = Optional.ofNullable((Map)shardingAlgorithmProvider.getIfAvailable()).orElse(Collections.emptyMap());
        Map keyGenerateAlgorithmMap = Optional.ofNullable((Map)keyGenerateAlgorithmProvider.getIfAvailable()).orElse(Collections.emptyMap());
        AlgorithmProvidedShardingRuleConfiguration result = this.swapper.swapToObject(this.yamlConfig.getSharding());
        result.setShardingAlgorithms(shardingAlgorithmMap);
        result.setKeyGenerators(keyGenerateAlgorithmMap);
        return result;
    }

    @Bean
    public static ShardingAlgorithmProvidedBeanRegistry shardingAlgorithmProvidedBeanRegistry(Environment environment) {
        return new ShardingAlgorithmProvidedBeanRegistry(environment);
    }

    @Bean
    public static KeyGenerateAlgorithmProvidedBeanRegistry keyGenerateAlgorithmProvidedBeanRegistry(Environment environment) {
        return new KeyGenerateAlgorithmProvidedBeanRegistry(environment);
    }

    @Generated
    public ShardingRuleSpringBootConfiguration(YamlShardingRuleSpringBootConfiguration yamlConfig) {
        this.yamlConfig = yamlConfig;
    }
}

