/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmeetings.model.Attendee;
import software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeListCopier;
import software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeErrorListCopier;
import software.amazon.awssdk.services.chimesdkmeetings.model.ChimeSdkMeetingsResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeError;
import software.amazon.awssdk.services.chimesdkmeetings.model.Meeting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMeetingWithAttendeesResponse
extends ChimeSdkMeetingsResponse
implements ToCopyableBuilder<Builder, CreateMeetingWithAttendeesResponse> {
    private static final SdkField<Meeting> MEETING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Meeting").getter(CreateMeetingWithAttendeesResponse.getter(CreateMeetingWithAttendeesResponse::meeting)).setter(CreateMeetingWithAttendeesResponse.setter(Builder::meeting)).constructor(Meeting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Meeting").build()}).build();
    private static final SdkField<List<Attendee>> ATTENDEES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attendees").getter(CreateMeetingWithAttendeesResponse.getter(CreateMeetingWithAttendeesResponse::attendees)).setter(CreateMeetingWithAttendeesResponse.setter(Builder::attendees)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendees").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attendee::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CreateAttendeeError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(CreateMeetingWithAttendeesResponse.getter(CreateMeetingWithAttendeesResponse::errors)).setter(CreateMeetingWithAttendeesResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateAttendeeError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_FIELD, ATTENDEES_FIELD, ERRORS_FIELD));
    private final Meeting meeting;
    private final List<Attendee> attendees;
    private final List<CreateAttendeeError> errors;

    private CreateMeetingWithAttendeesResponse(BuilderImpl builder) {
        super(builder);
        this.meeting = builder.meeting;
        this.attendees = builder.attendees;
        this.errors = builder.errors;
    }

    public final Meeting meeting() {
        return this.meeting;
    }

    public final boolean hasAttendees() {
        return this.attendees != null && !(this.attendees instanceof SdkAutoConstructList);
    }

    public final List<Attendee> attendees() {
        return this.attendees;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<CreateAttendeeError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.meeting());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttendees() ? this.attendees() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingWithAttendeesResponse)) {
            return false;
        }
        CreateMeetingWithAttendeesResponse other = (CreateMeetingWithAttendeesResponse)((Object)obj);
        return Objects.equals(this.meeting(), other.meeting()) && this.hasAttendees() == other.hasAttendees() && Objects.equals(this.attendees(), other.attendees()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMeetingWithAttendeesResponse").add("Meeting", (Object)this.meeting()).add("Attendees", this.hasAttendees() ? this.attendees() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Meeting": {
                return Optional.ofNullable(clazz.cast(this.meeting()));
            }
            case "Attendees": {
                return Optional.ofNullable(clazz.cast(this.attendees()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingWithAttendeesResponse, T> g) {
        return obj -> g.apply((CreateMeetingWithAttendeesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMeetingsResponse.BuilderImpl
    implements Builder {
        private Meeting meeting;
        private List<Attendee> attendees = DefaultSdkAutoConstructList.getInstance();
        private List<CreateAttendeeError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingWithAttendeesResponse model) {
            super(model);
            this.meeting(model.meeting);
            this.attendees(model.attendees);
            this.errors(model.errors);
        }

        public final Meeting.Builder getMeeting() {
            return this.meeting != null ? this.meeting.toBuilder() : null;
        }

        public final void setMeeting(Meeting.BuilderImpl meeting) {
            this.meeting = meeting != null ? meeting.build() : null;
        }

        @Override
        @Transient
        public final Builder meeting(Meeting meeting) {
            this.meeting = meeting;
            return this;
        }

        public final List<Attendee.Builder> getAttendees() {
            List<Attendee.Builder> result = AttendeeListCopier.copyToBuilder(this.attendees);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttendees(Collection<Attendee.BuilderImpl> attendees) {
            this.attendees = AttendeeListCopier.copyFromBuilder(attendees);
        }

        @Override
        @Transient
        public final Builder attendees(Collection<Attendee> attendees) {
            this.attendees = AttendeeListCopier.copy(attendees);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attendees(Attendee ... attendees) {
            this.attendees(Arrays.asList(attendees));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attendees(Consumer<Attendee.Builder> ... attendees) {
            this.attendees(Stream.of(attendees).map(c -> (Attendee)((Attendee.Builder)Attendee.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CreateAttendeeError.Builder> getErrors() {
            List<CreateAttendeeError.Builder> result = BatchCreateAttendeeErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<CreateAttendeeError.BuilderImpl> errors) {
            this.errors = BatchCreateAttendeeErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        @Transient
        public final Builder errors(Collection<CreateAttendeeError> errors) {
            this.errors = BatchCreateAttendeeErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(CreateAttendeeError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(Consumer<CreateAttendeeError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (CreateAttendeeError)((CreateAttendeeError.Builder)CreateAttendeeError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateMeetingWithAttendeesResponse build() {
            return new CreateMeetingWithAttendeesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMeetingsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMeetingWithAttendeesResponse> {
        public Builder meeting(Meeting var1);

        default public Builder meeting(Consumer<Meeting.Builder> meeting) {
            return this.meeting((Meeting)((Meeting.Builder)Meeting.builder().applyMutation(meeting)).build());
        }

        public Builder attendees(Collection<Attendee> var1);

        public Builder attendees(Attendee ... var1);

        public Builder attendees(Consumer<Attendee.Builder> ... var1);

        public Builder errors(Collection<CreateAttendeeError> var1);

        public Builder errors(CreateAttendeeError ... var1);

        public Builder errors(Consumer<CreateAttendeeError.Builder> ... var1);
    }
}

