/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationPreference;
import software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationUsageStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OnDemandCapacityReservationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OnDemandCapacityReservationOptions> {
    private static final SdkField<String> USAGE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageStrategy").getter(OnDemandCapacityReservationOptions.getter(OnDemandCapacityReservationOptions::usageStrategyAsString)).setter(OnDemandCapacityReservationOptions.setter(Builder::usageStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageStrategy").build()}).build();
    private static final SdkField<String> CAPACITY_RESERVATION_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationPreference").getter(OnDemandCapacityReservationOptions.getter(OnDemandCapacityReservationOptions::capacityReservationPreferenceAsString)).setter(OnDemandCapacityReservationOptions.setter(Builder::capacityReservationPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationPreference").build()}).build();
    private static final SdkField<String> CAPACITY_RESERVATION_RESOURCE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationResourceGroupArn").getter(OnDemandCapacityReservationOptions.getter(OnDemandCapacityReservationOptions::capacityReservationResourceGroupArn)).setter(OnDemandCapacityReservationOptions.setter(Builder::capacityReservationResourceGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationResourceGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_STRATEGY_FIELD, CAPACITY_RESERVATION_PREFERENCE_FIELD, CAPACITY_RESERVATION_RESOURCE_GROUP_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String usageStrategy;
    private final String capacityReservationPreference;
    private final String capacityReservationResourceGroupArn;

    private OnDemandCapacityReservationOptions(BuilderImpl builder) {
        this.usageStrategy = builder.usageStrategy;
        this.capacityReservationPreference = builder.capacityReservationPreference;
        this.capacityReservationResourceGroupArn = builder.capacityReservationResourceGroupArn;
    }

    public final OnDemandCapacityReservationUsageStrategy usageStrategy() {
        return OnDemandCapacityReservationUsageStrategy.fromValue(this.usageStrategy);
    }

    public final String usageStrategyAsString() {
        return this.usageStrategy;
    }

    public final OnDemandCapacityReservationPreference capacityReservationPreference() {
        return OnDemandCapacityReservationPreference.fromValue(this.capacityReservationPreference);
    }

    public final String capacityReservationPreferenceAsString() {
        return this.capacityReservationPreference;
    }

    public final String capacityReservationResourceGroupArn() {
        return this.capacityReservationResourceGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usageStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationResourceGroupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandCapacityReservationOptions)) {
            return false;
        }
        OnDemandCapacityReservationOptions other = (OnDemandCapacityReservationOptions)obj;
        return Objects.equals(this.usageStrategyAsString(), other.usageStrategyAsString()) && Objects.equals(this.capacityReservationPreferenceAsString(), other.capacityReservationPreferenceAsString()) && Objects.equals(this.capacityReservationResourceGroupArn(), other.capacityReservationResourceGroupArn());
    }

    public final String toString() {
        return ToString.builder((String)"OnDemandCapacityReservationOptions").add("UsageStrategy", (Object)this.usageStrategyAsString()).add("CapacityReservationPreference", (Object)this.capacityReservationPreferenceAsString()).add("CapacityReservationResourceGroupArn", (Object)this.capacityReservationResourceGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UsageStrategy": {
                return Optional.ofNullable(clazz.cast(this.usageStrategyAsString()));
            }
            case "CapacityReservationPreference": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationPreferenceAsString()));
            }
            case "CapacityReservationResourceGroupArn": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationResourceGroupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnDemandCapacityReservationOptions, T> g) {
        return obj -> g.apply((OnDemandCapacityReservationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String usageStrategy;
        private String capacityReservationPreference;
        private String capacityReservationResourceGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandCapacityReservationOptions model) {
            this.usageStrategy(model.usageStrategy);
            this.capacityReservationPreference(model.capacityReservationPreference);
            this.capacityReservationResourceGroupArn(model.capacityReservationResourceGroupArn);
        }

        public final String getUsageStrategy() {
            return this.usageStrategy;
        }

        public final void setUsageStrategy(String usageStrategy) {
            this.usageStrategy = usageStrategy;
        }

        @Override
        @Transient
        public final Builder usageStrategy(String usageStrategy) {
            this.usageStrategy = usageStrategy;
            return this;
        }

        @Override
        @Transient
        public final Builder usageStrategy(OnDemandCapacityReservationUsageStrategy usageStrategy) {
            this.usageStrategy(usageStrategy == null ? null : usageStrategy.toString());
            return this;
        }

        public final String getCapacityReservationPreference() {
            return this.capacityReservationPreference;
        }

        public final void setCapacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
        }

        @Override
        @Transient
        public final Builder capacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
            return this;
        }

        @Override
        @Transient
        public final Builder capacityReservationPreference(OnDemandCapacityReservationPreference capacityReservationPreference) {
            this.capacityReservationPreference(capacityReservationPreference == null ? null : capacityReservationPreference.toString());
            return this;
        }

        public final String getCapacityReservationResourceGroupArn() {
            return this.capacityReservationResourceGroupArn;
        }

        public final void setCapacityReservationResourceGroupArn(String capacityReservationResourceGroupArn) {
            this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
        }

        @Override
        @Transient
        public final Builder capacityReservationResourceGroupArn(String capacityReservationResourceGroupArn) {
            this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
            return this;
        }

        public OnDemandCapacityReservationOptions build() {
            return new OnDemandCapacityReservationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OnDemandCapacityReservationOptions> {
        public Builder usageStrategy(String var1);

        public Builder usageStrategy(OnDemandCapacityReservationUsageStrategy var1);

        public Builder capacityReservationPreference(String var1);

        public Builder capacityReservationPreference(OnDemandCapacityReservationPreference var1);

        public Builder capacityReservationResourceGroupArn(String var1);
    }
}

