/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeAsyncClient;
import software.amazon.awssdk.services.personalize.model.ListSolutionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionsResponse;
import software.amazon.awssdk.services.personalize.model.SolutionSummary;

public class ListSolutionsPublisher
implements SdkPublisher<ListSolutionsResponse> {
    private final PersonalizeAsyncClient client;
    private final ListSolutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSolutionsPublisher(PersonalizeAsyncClient client, ListSolutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSolutionsPublisher(PersonalizeAsyncClient client, ListSolutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSolutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSolutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SolutionSummary> solutions() {
        Function<ListSolutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.solutions() != null) {
                return response.solutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSolutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSolutionsResponseFetcher
    implements AsyncPageFetcher<ListSolutionsResponse> {
        private ListSolutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSolutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSolutionsResponse> nextPage(ListSolutionsResponse previousPage) {
            if (previousPage == null) {
                return ListSolutionsPublisher.this.client.listSolutions(ListSolutionsPublisher.this.firstRequest);
            }
            return ListSolutionsPublisher.this.client.listSolutions((ListSolutionsRequest)((Object)ListSolutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

