/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.nacos.client.transport;

import com.alibaba.cloud.ai.mcp.nacos.client.transport.LoadbalancedMcpAsyncClient;
import com.alibaba.cloud.ai.mcp.nacos.client.utils.NacosMcpClientUtils;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.cloud.ai.mcp.nacos.service.model.NacosMcpServerEndpoint;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointInfo;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.utils.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.WebFluxSseClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.client.autoconfigure.NamedClientMcpTransport;
import org.springframework.ai.mcp.client.autoconfigure.configurer.McpSyncClientConfigurer;
import org.springframework.ai.mcp.client.autoconfigure.properties.McpClientCommonProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;

public class LoadbalancedMcpSyncClient {
    private static final Logger logger = LoggerFactory.getLogger(LoadbalancedMcpAsyncClient.class);
    private final String serverName;
    private final NacosMcpOperationService nacosMcpOperationService;
    private final McpClientCommonProperties commonProperties;
    private final WebClient.Builder webClientBuilderTemplate;
    private final McpSyncClientConfigurer mcpSyncClientConfigurer;
    private final ObjectMapper objectMapper;
    private Map<String, McpSyncClient> keyToClientMap;
    private Map<String, Integer> keyToCountMap;
    private NacosMcpServerEndpoint serverEndpoint;
    private final ApplicationContext applicationContext;

    public LoadbalancedMcpSyncClient(String serverName, NacosMcpOperationService nacosMcpOperationService, ApplicationContext applicationContext) {
        Assert.notNull((Object)serverName, (String)"serviceName cannot be null");
        Assert.notNull((Object)nacosMcpOperationService, (String)"nacosMcpOperationService cannot be null");
        Assert.notNull((Object)applicationContext, (String)"applicationContext cannot be null");
        this.serverName = serverName;
        this.nacosMcpOperationService = nacosMcpOperationService;
        this.applicationContext = applicationContext;
        try {
            this.serverEndpoint = this.nacosMcpOperationService.getServerEndpoint(this.serverName);
            if (this.serverEndpoint == null) {
                throw new NacosException(404, String.format("Can not find mcp server from nacos: %s", serverName));
            }
            if (!StringUtils.equals((CharSequence)this.serverEndpoint.getProtocol(), (CharSequence)"mcp-sse")) {
                throw new Exception("mcp server protocol must be sse");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to get instances for service: %s", serverName));
        }
        this.commonProperties = (McpClientCommonProperties)this.applicationContext.getBean(McpClientCommonProperties.class);
        this.mcpSyncClientConfigurer = (McpSyncClientConfigurer)this.applicationContext.getBean(McpSyncClientConfigurer.class);
        this.objectMapper = (ObjectMapper)this.applicationContext.getBean(ObjectMapper.class);
        this.webClientBuilderTemplate = (WebClient.Builder)this.applicationContext.getBean(WebClient.Builder.class);
    }

    public void init() {
        this.keyToClientMap = new ConcurrentHashMap<String, McpSyncClient>();
        this.keyToCountMap = new ConcurrentHashMap<String, Integer>();
        for (McpEndpointInfo mcpEndpointInfo : this.serverEndpoint.getMcpEndpointInfoList()) {
            this.updateByAddEndpoint(mcpEndpointInfo, this.serverEndpoint.getExportPath());
        }
    }

    public void subscribe() {
        this.nacosMcpOperationService.subscribeNacosMcpServer(this.serverName, mcpServerDetailInfo -> {
            ArrayList<McpEndpointInfo> mcpEndpointInfoList = mcpServerDetailInfo.getBackendEndpoints() == null ? new ArrayList() : mcpServerDetailInfo.getBackendEndpoints();
            String exportPath = mcpServerDetailInfo.getRemoteServerConfig().getExportPath();
            String protocol = mcpServerDetailInfo.getProtocol();
            String realVersion = mcpServerDetailInfo.getVersionDetail().getVersion();
            NacosMcpServerEndpoint nacosMcpServerEndpoint = new NacosMcpServerEndpoint(mcpEndpointInfoList, exportPath, protocol, realVersion);
            this.updateClientList(nacosMcpServerEndpoint);
        });
    }

    public McpSyncClient getMcpSyncClient() {
        List<McpSyncClient> syncClients = this.getMcpSyncClientList();
        if (syncClients.isEmpty()) {
            throw new IllegalStateException("No McpAsyncClient available");
        }
        String key = this.keyToCountMap.entrySet().stream().min(Map.Entry.comparingByValue()).map(Map.Entry::getKey).get();
        this.keyToCountMap.put(key, this.keyToCountMap.get(key) + 1);
        return this.keyToClientMap.get(key);
    }

    public List<McpSyncClient> getMcpSyncClientList() {
        return this.keyToClientMap.values().stream().toList();
    }

    public String getServerName() {
        return this.serverName;
    }

    public NacosMcpServerEndpoint getNacosMcpServerEndpoint() {
        return this.serverEndpoint;
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.getMcpSyncClient().getServerCapabilities();
    }

    public McpSchema.Implementation getServerInfo() {
        return this.getMcpSyncClient().getServerInfo();
    }

    public McpSchema.ClientCapabilities getClientCapabilities() {
        return this.getMcpSyncClient().getClientCapabilities();
    }

    public McpSchema.Implementation getClientInfo() {
        return this.getMcpSyncClient().getClientInfo();
    }

    public void close() {
        Iterator<McpSyncClient> iterator = this.getMcpSyncClientList().iterator();
        while (iterator.hasNext()) {
            McpSyncClient mcpSyncClient = iterator.next();
            mcpSyncClient.close();
            iterator.remove();
            logger.info("Closed and removed McpSyncClient: {}", (Object)mcpSyncClient.getClientInfo().name());
        }
    }

    public boolean closeGracefully() {
        ArrayList<Boolean> flagList = new ArrayList<Boolean>();
        Iterator<McpSyncClient> iterator = this.getMcpSyncClientList().iterator();
        while (iterator.hasNext()) {
            McpSyncClient mcpSyncClient = iterator.next();
            boolean flag2 = mcpSyncClient.closeGracefully();
            flagList.add(flag2);
            if (!flag2) continue;
            iterator.remove();
            logger.info("Closed and removed McpSyncClient: {}", (Object)mcpSyncClient.getClientInfo().name());
        }
        return !flagList.stream().allMatch(flag -> flag);
    }

    public Object ping() {
        return this.getMcpSyncClient().ping();
    }

    public void addRoot(McpSchema.Root root) {
        for (McpSyncClient mcpSyncClient : this.getMcpSyncClientList()) {
            mcpSyncClient.addRoot(root);
        }
    }

    public void removeRoot(String rootUri) {
        for (McpSyncClient mcpSyncClient : this.getMcpSyncClientList()) {
            mcpSyncClient.removeRoot(rootUri);
        }
    }

    public McpSchema.CallToolResult callTool(McpSchema.CallToolRequest callToolRequest) {
        return this.getMcpSyncClient().callTool(callToolRequest);
    }

    public McpSchema.ListToolsResult listTools() {
        return this.listToolsInternal(null);
    }

    public McpSchema.ListToolsResult listTools(String cursor) {
        return this.listToolsInternal(cursor);
    }

    private McpSchema.ListToolsResult listToolsInternal(String cursor) {
        return this.getMcpSyncClient().listTools(cursor);
    }

    public McpSchema.ListResourcesResult listResources(String cursor) {
        return this.getMcpSyncClient().listResources(cursor);
    }

    public McpSchema.ListResourcesResult listResources() {
        return this.getMcpSyncClient().listResources();
    }

    public McpSchema.ReadResourceResult readResource(McpSchema.Resource resource) {
        return this.getMcpSyncClient().readResource(resource);
    }

    public McpSchema.ReadResourceResult readResource(McpSchema.ReadResourceRequest readResourceRequest) {
        return this.getMcpSyncClient().readResource(readResourceRequest);
    }

    public McpSchema.ListResourceTemplatesResult listResourceTemplates(String cursor) {
        return this.getMcpSyncClient().listResourceTemplates(cursor);
    }

    public McpSchema.ListResourceTemplatesResult listResourceTemplates() {
        return this.getMcpSyncClient().listResourceTemplates();
    }

    public void subscribeResource(McpSchema.SubscribeRequest subscribeRequest) {
        for (McpSyncClient mcpSyncClient : this.getMcpSyncClientList()) {
            mcpSyncClient.subscribeResource(subscribeRequest);
        }
    }

    public void unsubscribeResource(McpSchema.UnsubscribeRequest unsubscribeRequest) {
        for (McpSyncClient mcpSyncClient : this.getMcpSyncClientList()) {
            mcpSyncClient.unsubscribeResource(unsubscribeRequest);
        }
    }

    public McpSchema.ListPromptsResult listPrompts(String cursor) {
        return this.getMcpSyncClient().listPrompts(cursor);
    }

    public McpSchema.ListPromptsResult listPrompts() {
        return this.getMcpSyncClient().listPrompts();
    }

    public McpSchema.GetPromptResult getPrompt(McpSchema.GetPromptRequest getPromptRequest) {
        return this.getMcpSyncClient().getPrompt(getPromptRequest);
    }

    public void setLoggingLevel(McpSchema.LoggingLevel loggingLevel) {
        for (McpSyncClient mcpSyncClient : this.getMcpSyncClientList()) {
            mcpSyncClient.setLoggingLevel(loggingLevel);
        }
    }

    private McpSyncClient clientByEndpoint(McpEndpointInfo mcpEndpointInfo, String exportPath) {
        String baseUrl = "http://" + mcpEndpointInfo.getAddress() + ":" + mcpEndpointInfo.getPort();
        WebClient.Builder webClientBuilder = this.webClientBuilderTemplate.clone().baseUrl(baseUrl);
        WebFluxSseClientTransport transport = new WebFluxSseClientTransport(webClientBuilder, this.objectMapper, exportPath);
        NamedClientMcpTransport namedTransport = new NamedClientMcpTransport(this.serverName + "-" + NacosMcpClientUtils.getMcpEndpointInfoId(mcpEndpointInfo, exportPath), (McpClientTransport)transport);
        McpSchema.Implementation clientInfo = new McpSchema.Implementation(this.connectedClientName(this.commonProperties.getName(), namedTransport.name()), this.commonProperties.getVersion());
        McpClient.SyncSpec syncSpec = McpClient.sync((McpClientTransport)namedTransport.transport()).clientInfo(clientInfo).requestTimeout(this.commonProperties.getRequestTimeout());
        syncSpec = this.mcpSyncClientConfigurer.configure(namedTransport.name(), syncSpec);
        McpSyncClient syncClient = syncSpec.build();
        if (this.commonProperties.isInitialized()) {
            syncClient.initialize();
        }
        logger.info("Added McpSyncClient: {}", (Object)clientInfo.name());
        return syncClient;
    }

    private void updateByAddEndpoint(McpEndpointInfo serverEndpoint, String exportPath) {
        McpSyncClient mcpSyncClient = this.clientByEndpoint(serverEndpoint, exportPath);
        String key = NacosMcpClientUtils.getMcpEndpointInfoId(serverEndpoint, exportPath);
        this.keyToClientMap.putIfAbsent(key, mcpSyncClient);
        this.keyToCountMap.putIfAbsent(key, 0);
    }

    private void updateClientList(NacosMcpServerEndpoint newServerEndpoint) {
        if (!StringUtils.equals((CharSequence)this.serverEndpoint.getExportPath(), (CharSequence)newServerEndpoint.getExportPath()) || !StringUtils.equals((CharSequence)this.serverEndpoint.getVersion(), (CharSequence)newServerEndpoint.getVersion())) {
            this.updateAll(newServerEndpoint);
        } else {
            List<McpEndpointInfo> currentMcpEndpointInfoList = this.serverEndpoint.getMcpEndpointInfoList();
            List<McpEndpointInfo> newMcpEndpointInfoList = newServerEndpoint.getMcpEndpointInfoList();
            List<McpEndpointInfo> addEndpointInfoList = newMcpEndpointInfoList.stream().filter(newEndpoint -> currentMcpEndpointInfoList.stream().noneMatch(currentEndpoint -> currentEndpoint.getAddress().equals(newEndpoint.getAddress()) && currentEndpoint.getPort() == newEndpoint.getPort())).toList();
            List<McpEndpointInfo> removeEndpointInfoList = currentMcpEndpointInfoList.stream().filter(currentEndpoint -> newMcpEndpointInfoList.stream().noneMatch(newEndpoint -> newEndpoint.getAddress().equals(currentEndpoint.getAddress()) && newEndpoint.getPort() == currentEndpoint.getPort())).toList();
            for (McpEndpointInfo addEndpointInfo : addEndpointInfoList) {
                this.updateByAddEndpoint(addEndpointInfo, newServerEndpoint.getExportPath());
            }
            for (McpEndpointInfo removeEndpointInfo : removeEndpointInfoList) {
                this.updateByRemoveEndpoint(removeEndpointInfo, newServerEndpoint.getExportPath());
            }
        }
        this.serverEndpoint = newServerEndpoint;
    }

    private void updateAll(NacosMcpServerEndpoint newServerEndpoint) {
        McpSyncClient syncClient;
        ConcurrentHashMap<String, McpSyncClient> newKeyToClientMap = new ConcurrentHashMap<String, McpSyncClient>();
        Map<String, McpSyncClient> oldKeyToClientMap = this.keyToClientMap;
        ConcurrentHashMap<String, Integer> newKeyToCountMap = new ConcurrentHashMap<String, Integer>();
        for (McpEndpointInfo mcpEndpointInfo : newServerEndpoint.getMcpEndpointInfoList()) {
            syncClient = this.clientByEndpoint(mcpEndpointInfo, newServerEndpoint.getExportPath());
            String key = NacosMcpClientUtils.getMcpEndpointInfoId(mcpEndpointInfo, newServerEndpoint.getExportPath());
            newKeyToClientMap.putIfAbsent(key, syncClient);
            newKeyToCountMap.putIfAbsent(key, 0);
        }
        this.keyToClientMap = newKeyToClientMap;
        this.keyToCountMap = newKeyToCountMap;
        for (Map.Entry entry : oldKeyToClientMap.entrySet()) {
            syncClient = (McpSyncClient)entry.getValue();
            logger.info("Removing McpSyncClient: {}", (Object)syncClient.getClientInfo().name());
            syncClient.closeGracefully();
            logger.info("Removed McpSyncClient: {} Success", (Object)syncClient.getClientInfo().name());
        }
    }

    private void updateByRemoveEndpoint(McpEndpointInfo serverEndpoint, String exportPath) {
        String key = NacosMcpClientUtils.getMcpEndpointInfoId(serverEndpoint, exportPath);
        if (this.keyToClientMap.containsKey(key)) {
            McpSyncClient syncClient = this.keyToClientMap.remove(key);
            logger.info("Removing McpSyncClient: {}", (Object)syncClient.getClientInfo().name());
            syncClient.closeGracefully();
            this.keyToCountMap.remove(key);
            logger.info("Removed McpSyncClient: {} Success", (Object)syncClient.getClientInfo().name());
        }
    }

    private String connectedClientName(String clientName, String serverConnectionName) {
        return clientName + " - " + serverConnectionName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String serverName;
        private NacosMcpOperationService nacosMcpOperationService;
        private ApplicationContext applicationContext;

        public Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public Builder nacosMcpOperationService(NacosMcpOperationService nacosMcpOperationService) {
            this.nacosMcpOperationService = nacosMcpOperationService;
            return this;
        }

        public Builder applicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
            return this;
        }

        public LoadbalancedMcpSyncClient build() {
            return new LoadbalancedMcpSyncClient(this.serverName, this.nacosMcpOperationService, this.applicationContext);
        }
    }
}

