/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.vectorstore.oceanbase;

import com.alibaba.cloud.ai.vectorstore.oceanbase.OceanBaseVectorStore;
import com.alibaba.cloud.ai.vectorstore.oceanbase.OceanBaseVectorStoreProperties;
import io.micrometer.observation.ObservationRegistry;
import javax.sql.DataSource;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@AutoConfiguration
@ConditionalOnClass(value={EmbeddingModel.class, OceanBaseVectorStore.class})
@EnableConfigurationProperties(value={OceanBaseVectorStoreProperties.class})
@ConditionalOnProperty(prefix="spring.ai.vectorstore.oceanbase", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class OceanBaseVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DataSource oceanbaseDataSource(OceanBaseVectorStoreProperties properties) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setUrl(properties.getUrl());
        dataSource.setUsername(properties.getUsername());
        dataSource.setPassword(properties.getPassword());
        return dataSource;
    }

    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    public BatchingStrategy oceanbaseBatchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public OceanBaseVectorStore oceanBaseVectorStore(DataSource dataSource, EmbeddingModel embeddingModel, OceanBaseVectorStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        OceanBaseVectorStore.Builder builder = (OceanBaseVectorStore.Builder)((OceanBaseVectorStore.Builder)((OceanBaseVectorStore.Builder)OceanBaseVectorStore.builder(properties.getTableName(), dataSource, embeddingModel).batchingStrategy(batchingStrategy)).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP))).customObservationConvention((VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null));
        if (properties.getDefaultTopK() >= 0) {
            builder.defaultTopK(properties.getDefaultTopK());
        }
        if (properties.getDefaultSimilarityThreshold() >= 0.0) {
            builder.defaultSimilarityThreshold(properties.getDefaultSimilarityThreshold());
        }
        return builder.build();
    }
}

