/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.baidumap;

import com.alibaba.cloud.ai.toolcalling.baidumap.BaiDuMapProperties;
import com.alibaba.cloud.ai.toolcalling.baidumap.BaiDuMapTools;
import com.alibaba.cloud.ai.toolcalling.baidumap.BaiDuMapWeatherService;
import com.alibaba.cloud.ai.toolcalling.baidumap.BaiduMapSearchInfoService;
import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;

@Configuration
@EnableConfigurationProperties(value={BaiDuMapProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.baidu.map", name={"enabled"}, havingValue="true")
public class BaiDuMapAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(BaiDuMapAutoConfiguration.class);

    @Bean
    @Description(value="Search for places using Baidu Maps API or Get detail information of a address and facility query with baidu map or Get address information of a place with baidu map or Get detailed information about a specific place with baidu map")
    public BaiduMapSearchInfoService baiduMapGetAddressInformation(BaiDuMapTools baiDuMapTools) {
        logger.debug("baiduMapSearchInfoService is enabled.");
        return new BaiduMapSearchInfoService(baiDuMapTools);
    }

    @Bean
    @Description(value="Query the weather conditions of a specified location")
    public BaiDuMapWeatherService baiDuMapGetAddressWeatherInformation(JsonParseTool jsonParseTool, BaiDuMapTools baiDuMapTools) {
        logger.debug("baiDuMapWeatherService is enabled.");
        return new BaiDuMapWeatherService(jsonParseTool, baiDuMapTools);
    }

    @Bean
    public BaiDuMapTools baiDuMapTools(BaiDuMapProperties properties, JsonParseTool jsonParseTool) {
        return new BaiDuMapTools(properties, WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).build(), jsonParseTool);
    }
}

