/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.baidumap;

import com.alibaba.cloud.ai.toolcalling.baidumap.BaiDuMapProperties;
import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallUtils;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Objects;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class BaiDuMapTools {
    private final BaiDuMapProperties baiDuMapProperties;
    private final WebClientTool webClientTool;
    private final JsonParseTool jsonParseTool;

    public BaiDuMapTools(BaiDuMapProperties baiDuMapProperties, WebClientTool webClientTool, JsonParseTool jsonParseTool) {
        this.baiDuMapProperties = baiDuMapProperties;
        this.webClientTool = webClientTool;
        this.jsonParseTool = jsonParseTool;
        if (Objects.isNull(baiDuMapProperties.getApiKey())) {
            throw new RuntimeException("Please configure your BaiDuMap API key in the application.yml file.");
        }
    }

    public Region getRegionInformation(String regionName, Integer depth) {
        String path = "/api_region_search/v1/";
        MultiValueMap params = CommonToolCallUtils.multiValueMapBuilder().add((Object)"ak", (Object)this.baiDuMapProperties.getApiKey()).add((Object)"keyword", (Object)regionName).add((Object)"sub_admin", (Object)depth.toString()).add((Object)"extensions_code", (Object)"1").build();
        try {
            String response = (String)this.webClientTool.get(path, params).block();
            return (Region)this.jsonParseTool.jsonToObject(response, (TypeReference)new TypeReference<Region>(){});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get address city code", e);
        }
    }

    public String getWeather(String cityCode) {
        String path = "/weather/v1/";
        MultiValueMap params = CommonToolCallUtils.multiValueMapBuilder().add((Object)"ak", (Object)this.baiDuMapProperties.getApiKey()).add((Object)"district_id", (Object)cityCode).add((Object)"data_type", (Object)"all").build();
        try {
            return (String)this.webClientTool.get(path, params).block();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get weather information", e);
        }
    }

    public String getAddressInformation(String region, String queryPlace, boolean isDetail) {
        String path = "/place/v2/search/";
        MultiValueMap params = CommonToolCallUtils.multiValueMapBuilder().add((Object)"ak", (Object)this.baiDuMapProperties.getApiKey()).add((Object)"query", (Object)queryPlace).add((Object)"region", (Object)(StringUtils.hasText((String)region) ? region : "china")).add((Object)"output", (Object)"json").add((Object)"scope", (Object)(isDetail ? "2" : "1")).build();
        try {
            return (String)this.webClientTool.get(path, params).block();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get information", e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Region(Integer status, List<District> districts) {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record District(String code, String name, Integer level, List<District> districts) {
    }
}

