/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.common;

import java.io.IOException;
import java.net.URI;
import java.util.function.Function;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.publisher.Mono;

public final class CommonToolCallConstants {
    public static final String TOOL_CALLING_CONFIG_PREFIX = "spring.ai.alibaba.toolcalling";
    public static final String DEFAULT_BASE_URL = "/";
    public static final int DEFAULT_NETWORK_TIMEOUT = 10;
    private static final int MEMORY_SIZE = 5;
    private static final int BYTE_SIZE = 1024;
    public static final int MAX_MEMORY_SIZE = 0x500000;
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 5000;
    public static final int DEFAULT_RESPONSE_TIMEOUT_SECONDS = 10;
    public static final String[] DEFAULT_USER_AGENTS = new String[]{"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36"};
    public static final ResponseErrorHandler DEFAULT_RESTCLIENT_ERROR_HANDLER = new ResponseErrorHandler(){

        public boolean hasError(ClientHttpResponse response) throws IOException {
            return response.getStatusCode().isError();
        }

        public void handleError(URI url, HttpMethod method, ClientHttpResponse response) throws IOException {
            throw new RuntimeException("Server error, code: " + response.getStatusCode() + ", message: " + response.getStatusText());
        }
    };
    public static final Function<ClientResponse, Mono<? extends Throwable>> DEFAULT_WEBCLIENT_4XX_EXCEPTION = response -> Mono.error((Throwable)new RuntimeException("Server error, code: " + response.statusCode().value()));
    public static final Function<ClientResponse, Mono<? extends Throwable>> DEFAULT_WEBCLIENT_5XX_EXCEPTION = response -> Mono.error((Throwable)new RuntimeException("Server error, code: " + response.statusCode().value()));
}

