/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.githubtoolkit;

import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.githubtoolkit.GithubToolKitProperties;
import com.alibaba.cloud.ai.toolcalling.githubtoolkit.Response;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetIssueService
implements Function<Request, Response> {
    private static final String REPO_ENDPOINT = "/repos/{owner}/{repo}";
    private static final String ISSUES_ENDPOINT = "/issues";
    private static final Logger logger = LoggerFactory.getLogger(GetIssueService.class);
    private final WebClientTool webClientTool;
    private final JsonParseTool jsonParseTool;
    private final GithubToolKitProperties properties;

    public GetIssueService(GithubToolKitProperties properties, WebClientTool webClientTool, JsonParseTool jsonParseTool) {
        assert (properties.getToken() != null && properties.getToken().length() == 40);
        this.properties = properties;
        this.webClientTool = webClientTool;
        this.jsonParseTool = jsonParseTool;
    }

    @Override
    public Response apply(Request request) {
        try {
            String endpoint = "/repos/{owner}/{repo}/issues/{issueNumber}";
            String responseData = (String)this.webClientTool.get(endpoint, Map.of("owner", this.properties.getOwner(), "repo", this.properties.getRepository(), "issueNumber", request.issueNumber())).block();
            logger.info("GetIssueOperation response: {}", (Object)responseData);
            return new Response<Issue>(this.parseIssueDetails(responseData));
        }
        catch (IOException e) {
            logger.error("Error occurred while parsing response: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public Issue parseIssueDetails(String json) throws JsonProcessingException {
        long id = Long.parseLong(this.jsonParseTool.getFieldValueAsString(json, "id"));
        String title = this.jsonParseTool.getFieldValueAsString(json, "title").replaceAll("\"", "");
        String state = this.jsonParseTool.getFieldValueAsString(json, "state").replaceAll("\"", "");
        String createdAt = this.jsonParseTool.getFieldValueAsString(json, "created_at").replaceAll("\"", "");
        String updatedAt = this.jsonParseTool.getFieldValueAsString(json, "updated_at").replaceAll("\"", "");
        int comments = Integer.parseInt(this.jsonParseTool.getFieldValueAsString(json, "comments"));
        String htmlUrl = this.jsonParseTool.getFieldValueAsString(json, "html_url").replaceAll("\"", "");
        String body = this.jsonParseTool.getFieldValueAsString(json, "body").replaceAll("\"", "");
        String closedAt = this.jsonParseTool.getFieldValueAsString(json, "closed_at").replaceAll("\"", "");
        String userLogin = this.jsonParseTool.getDepthFieldValueAsString(json, new String[]{"user", "login"}).replaceAll("\"", "");
        String closedBy = this.jsonParseTool.getDepthFieldValueAsString(json, new String[]{"closed_by", "login"}).replaceAll("\"", "");
        ArrayList<String> labels = new ArrayList();
        try {
            List labelObjects = (List)this.jsonParseTool.getFieldValue(json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, "labels");
            if (labelObjects != null) {
                labels = labelObjects.stream().map(labelMap -> (String)labelMap.get("name")).filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            logger.warn("Failed to parse labels from JSON: {}", (Object)e.getMessage());
            labels = new ArrayList();
        }
        List<String> assignees = new ArrayList<String>();
        try {
            List assigneeObjects = (List)this.jsonParseTool.getFieldValue(json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, "assignees");
            if (assigneeObjects != null) {
                assignees = assigneeObjects.stream().map(assigneeMap -> (String)assigneeMap.get("login")).filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            logger.warn("Failed to parse assignees from JSON: {}", (Object)e.getMessage());
            assignees = new ArrayList();
        }
        return new Issue(id, title, body, state, userLogin, labels, assignees, createdAt, updatedAt, closedAt, closedBy, comments, htmlUrl);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="GitHub Issue request")
    public record Request(@JsonProperty(required=true, value="issueNumber") @JsonPropertyDescription(value="The number of the issue, which is used to get details about the issue or to leave a comment") Integer issueNumber) {
    }

    public record Issue(long id, String title, String body, String state, String userLogin, List<String> labels, List<String> assignees, String createdAt, String updatedAt, String closedAt, String closedBy, int comments, String htmlUrl) {
    }
}

