/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.jinacrawler;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.jinacrawler.JinaCrawlerProperties;
import com.alibaba.cloud.ai.toolcalling.jinacrawler.JinaCrawlerService;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={JinaCrawlerProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.jinacrawler", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class JinaCrawlerAutoConfiguration {
    @Bean(name={"jinaCrawler"})
    @ConditionalOnMissingBean
    @Description(value="Jina Reader Service Plugin.")
    public JinaCrawlerService jinaCrawler(JsonParseTool jsonParseTool, JinaCrawlerProperties jinaProperties) {
        Consumer<HttpHeaders> consumer = httpHeaders -> {
            httpHeaders.add("Accept", jinaProperties.getAccept().toString());
            httpHeaders.add("Content-Type", "application/json");
            httpHeaders.add("Authorization", "Bearer " + jinaProperties.getApiKey());
            if (StringUtils.hasText((String)jinaProperties.getLocale())) {
                httpHeaders.add("X-Locale", jinaProperties.getLocale());
            }
            if (Objects.nonNull(jinaProperties.getNoCache())) {
                httpHeaders.add("X-No-Cache", jinaProperties.getNoCache().toString());
            }
            if (StringUtils.hasText((String)jinaProperties.getProxyUrl())) {
                httpHeaders.add("X-Proxy-Url", jinaProperties.getProxyUrl());
            }
            if (StringUtils.hasText((String)jinaProperties.getRemoveSelector())) {
                httpHeaders.add("X-Remove-Selector", jinaProperties.getRemoveSelector());
            }
            if (StringUtils.hasText((String)jinaProperties.getRetainImages())) {
                httpHeaders.add("X-Retain-Images", jinaProperties.getRetainImages());
            }
            if (StringUtils.hasText((String)jinaProperties.getSetCookie())) {
                httpHeaders.add("X-Set-Cookie", jinaProperties.getSetCookie());
            }
            if (Objects.nonNull(jinaProperties.getWithGeneratedAlt())) {
                httpHeaders.add("X-With-Generated-Alt", jinaProperties.getWithGeneratedAlt().toString());
            }
            if (Objects.nonNull(jinaProperties.getWithIframe())) {
                httpHeaders.add("X-With-Iframe", jinaProperties.getWithIframe().toString());
            }
            if (Objects.nonNull(jinaProperties.getWithShadowDom())) {
                httpHeaders.add("X-With-Shadow-Dom", jinaProperties.getWithShadowDom().toString());
            }
            if (Objects.nonNull(jinaProperties.getWithImagesSummary())) {
                httpHeaders.add("X-With-Images-Summary", jinaProperties.getWithImagesSummary().toString());
            }
            if (Objects.nonNull(jinaProperties.getWithLinksSummary())) {
                httpHeaders.add("X-With-Links-Summary", jinaProperties.getWithLinksSummary().toString());
            }
            if (StringUtils.hasText((String)jinaProperties.getTargetSelector())) {
                httpHeaders.add("X-Target-Selector", jinaProperties.getTargetSelector());
            }
            if (StringUtils.hasText((String)jinaProperties.getWaitForSelector())) {
                httpHeaders.add("X-Wait-For-Selector", jinaProperties.getWaitForSelector());
            }
        };
        return new JinaCrawlerService(jsonParseTool, WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)jinaProperties).httpHeadersConsumer(consumer).build(), jinaProperties);
    }
}

