/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.openalex;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.openalex.OpenAlexProperties;
import com.alibaba.cloud.ai.toolcalling.openalex.OpenAlexService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;

@Configuration
@EnableConfigurationProperties(value={OpenAlexProperties.class})
@ConditionalOnClass(value={OpenAlexService.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.openalex", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class OpenAlexAutoConfiguration {
    @Bean(name={"openAlex"})
    @ConditionalOnMissingBean
    @Description(value="OpenAlex Academic Search Service")
    public OpenAlexService openAlexService(OpenAlexProperties properties, JsonParseTool jsonParseTool) {
        WebClientTool webClientTool = WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).httpHeadersConsumer(httpHeaders -> {
            httpHeaders.add("User-Agent", "Spring AI Alibaba Tool Calling / OpenAlex (mailto:your-email@example.com)");
            httpHeaders.add("Accept", "application/json");
        }).build();
        return new OpenAlexService(properties, jsonParseTool, webClientTool);
    }
}

