/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.opentripmap;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallUtils;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.common.interfaces.SearchService;
import com.alibaba.cloud.ai.toolcalling.opentripmap.OpenTripMapProperties;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OpenTripMapService
implements SearchService,
Function<Request, Response> {
    private static final Logger logger = LoggerFactory.getLogger(OpenTripMapService.class);
    private final WebClientTool webClientTool;
    private final JsonParseTool jsonParseTool;
    private final OpenTripMapProperties properties;

    public OpenTripMapService(WebClientTool webClientTool, JsonParseTool jsonParseTool, OpenTripMapProperties properties) {
        this.webClientTool = webClientTool;
        this.jsonParseTool = jsonParseTool;
        this.properties = properties;
    }

    public SearchService.Response query(String query) {
        return (SearchService.Response)CommonToolCallUtils.handleServiceError((String)"OpenTripMap", () -> {
            Request coordRequest = new Request(null, null, null, null, null, null, query, null, "coordinates");
            Response coordResponse = this.apply(coordRequest);
            if (coordResponse != null && coordResponse.coordinates != null) {
                try {
                    Double lon;
                    Double lat;
                    Request searchRequest;
                    Response searchResponse;
                    Map coordData = (Map)this.jsonParseTool.jsonToObject(coordResponse.coordinates, (TypeReference)new TypeReference<Map<String, Object>>(){});
                    if (coordData.containsKey("lat") && coordData.containsKey("lon") && (searchResponse = this.apply(searchRequest = new Request(lat = Double.valueOf(coordData.get("lat").toString()), lon = Double.valueOf(coordData.get("lon").toString()), 5000, 20, null, null, null, null, "search"))) != null && StringUtils.hasText((String)searchResponse.places)) {
                        List places = (List)this.jsonParseTool.jsonToObject(searchResponse.places, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                        ArrayList<SearchService.SearchContent> contents = new ArrayList<SearchService.SearchContent>();
                        for (Map place : places) {
                            String name = (String)place.get("name");
                            String kinds = (String)place.get("kinds");
                            contents.add(new SearchService.SearchContent(name != null ? name : "Unknown Place", kinds != null ? kinds : "Tourist attraction", "https://www.opentripmap.com/en/#13/" + lat + "/" + lon, null));
                        }
                        return () -> new SearchService.SearchResult(contents);
                    }
                }
                catch (Exception e) {
                    logger.warn("Failed to parse coordinates: {}", (Object)e.getMessage());
                }
            }
            return () -> new SearchService.SearchResult(new ArrayList());
        }, (Logger)logger);
    }

    @Override
    public Response apply(Request request) {
        if (CommonToolCallUtils.isInvalidateRequestParams((Object[])new Object[]{request})) {
            logger.error("Invalid request: request cannot be null");
            return null;
        }
        return (Response)CommonToolCallUtils.handleServiceError((String)"OpenTripMap", () -> {
            if ("coordinates".equals(request.operation) && StringUtils.hasText((String)request.placeName)) {
                String responseData = this.getCoordinates(request.placeName);
                return new Response(null, null, responseData);
            }
            if ("details".equals(request.operation) && StringUtils.hasText((String)request.xid)) {
                String responseData = this.getPlaceDetails(request.xid);
                return new Response(null, responseData, null);
            }
            if ("search".equals(request.operation) && request.latitude != null && request.longitude != null) {
                String responseData = this.searchPlaces(request);
                return new Response(responseData, null, null);
            }
            logger.error("Invalid request: missing required parameters for operation {}", (Object)request.operation);
            return null;
        }, (Logger)logger);
    }

    private String searchPlaces(Request request) {
        MultiValueMap params = CommonToolCallUtils.multiValueMapBuilder().add((Object)"apikey", (Object)this.properties.getApiKey()).add((Object)"lon", (Object)String.valueOf(request.longitude)).add((Object)"lat", (Object)String.valueOf(request.latitude)).add((Object)"radius", (Object)String.valueOf(request.radius != null ? request.radius : 1000)).add((Object)"limit", (Object)String.valueOf(request.limit != null ? request.limit : 10)).add((Object)"format", (Object)"json").build();
        if (StringUtils.hasText((String)request.kinds)) {
            params.add((Object)"kinds", (Object)request.kinds);
        }
        if (StringUtils.hasText((String)request.rate)) {
            params.add((Object)"rate", (Object)request.rate);
        }
        String response = (String)this.webClientTool.get("/places/radius", params).block();
        logger.info("OpenTripMap places search completed for coordinates: {}, {}", (Object)request.latitude, (Object)request.longitude);
        return response;
    }

    private String getPlaceDetails(String xid) {
        MultiValueMap params = CommonToolCallUtils.multiValueMapBuilder().add((Object)"apikey", (Object)this.properties.getApiKey()).build();
        String response = (String)this.webClientTool.get("/places/xid/" + xid, params).block();
        logger.info("OpenTripMap place details retrieved for xid: {}", (Object)xid);
        return response;
    }

    private String getCoordinates(String placeName) {
        MultiValueMap params = CommonToolCallUtils.multiValueMapBuilder().add((Object)"apikey", (Object)this.properties.getApiKey()).add((Object)"name", (Object)placeName).build();
        String response = (String)this.webClientTool.get("/places/geoname", params).block();
        logger.info("OpenTripMap coordinates retrieved for place: {}", (Object)placeName);
        return response;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="OpenTripMap service for searching places, getting place details, or finding coordinates.")
    public record Request(@JsonProperty(value="latitude") @JsonPropertyDescription(value="Latitude coordinate for place search") Double latitude, @JsonProperty(value="longitude") @JsonPropertyDescription(value="Longitude coordinate for place search") Double longitude, @JsonProperty(value="radius") @JsonPropertyDescription(value="Search radius in meters (default: 1000, max: 50000)") Integer radius, @JsonProperty(value="limit") @JsonPropertyDescription(value="Maximum number of results (default: 10, max: 500)") Integer limit, @JsonProperty(value="kinds") @JsonPropertyDescription(value="Categories of places (e.g., 'museums', 'restaurants', 'hotels')") String kinds, @JsonProperty(value="rate") @JsonPropertyDescription(value="Minimum rating (1-3, where 3 is highest)") String rate, @JsonProperty(value="placeName") @JsonPropertyDescription(value="Place name to get coordinates for") String placeName, @JsonProperty(value="xid") @JsonPropertyDescription(value="Unique place identifier for getting details") String xid, @JsonProperty(required=true, value="operation") @JsonPropertyDescription(value="Operation type: 'search' (find places), 'details' (get place details), 'coordinates' (get coordinates for place name)") String operation) implements SearchService.Request
    {
        public String getQuery() {
            return this.placeName != null ? this.placeName : (this.operation != null ? this.operation : "");
        }
    }

    @JsonClassDescription(value="OpenTripMap service response")
    public record Response(String places, String details, String coordinates) implements SearchService.Response
    {
        public SearchService.SearchResult getSearchResult() {
            return new SearchService.SearchResult(new ArrayList());
        }
    }
}

