/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;

public class InetIPv6Utils
implements Closeable {
    private final ExecutorService executorService;
    private final Log log = LogFactory.getLog(InetIPv6Utils.class);
    private final InetUtilsProperties properties;

    @Override
    public void close() {
        this.executorService.shutdown();
    }

    public InetIPv6Utils(InetUtilsProperties properties) {
        this.properties = properties;
        this.executorService = Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setName("spring.cloud.alibaba.inetutilsIPV6");
            thread.setDaemon(true);
            return thread;
        });
    }

    public InetUtils.HostInfo findFirstNonLoopbackHostInfo() {
        InetAddress address = this.findFirstNonLoopbackIPv6Address();
        if (address != null) {
            return this.convertAddress(address);
        }
        InetUtils.HostInfo hostInfo = new InetUtils.HostInfo();
        this.properties.setDefaultIpAddress("0:0:0:0:0:0:0:1");
        hostInfo.setHostname(this.properties.getDefaultHostname());
        hostInfo.setIpAddress(this.properties.getDefaultIpAddress());
        return hostInfo;
    }

    public InetAddress findFirstNonLoopbackIPv6Address() {
        InetAddress address = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                this.log.trace((Object)("Testing interface:" + ifc.getDisplayName()));
                if (ifc.getIndex() < lowest || address == null) {
                    lowest = ifc.getIndex();
                } else if (address != null) continue;
                if (this.ignoreInterface(ifc.getDisplayName())) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress inetAddress = addrs.nextElement();
                    if (!(inetAddress instanceof Inet6Address) || inetAddress.isLoopbackAddress() || !this.isPreferredAddress(inetAddress)) continue;
                    this.log.trace((Object)("Found non-loopback interface: " + ifc.getDisplayName()));
                    address = inetAddress;
                }
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Cannot get first non-loopback address", (Throwable)e);
        }
        if (address != null) {
            return address;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            this.log.warn((Object)"Unable to retrieve localhost");
            return null;
        }
    }

    public String findIPv6Address() {
        String ip = this.findFirstNonLoopbackHostInfo().getIpAddress();
        int index = ip.indexOf(37);
        ip = index > 0 ? ip.substring(0, index) : ip;
        return this.iPv6Format(ip);
    }

    public String iPv6Format(String ip) {
        return "[" + ip + "]";
    }

    boolean isPreferredAddress(InetAddress address) {
        if (this.properties.isUseOnlySiteLocalInterfaces()) {
            boolean siteLocalAddress = address.isSiteLocalAddress();
            if (!siteLocalAddress) {
                this.log.trace((Object)("Ignoring address" + address.getHostAddress()));
            }
            return siteLocalAddress;
        }
        List preferredNetworks = this.properties.getPreferredNetworks();
        if (preferredNetworks.isEmpty()) {
            return true;
        }
        for (String regex : preferredNetworks) {
            String hostAddress = address.getHostAddress();
            if (!hostAddress.matches(regex) && !hostAddress.startsWith(regex)) continue;
            return true;
        }
        this.log.trace((Object)("Ignoring address: " + address.getHostAddress()));
        return false;
    }

    boolean ignoreInterface(String interfaceName) {
        for (String regex : this.properties.getIgnoredInterfaces()) {
            if (!interfaceName.matches(regex)) continue;
            this.log.trace((Object)("Ignoring interface: " + interfaceName));
            return true;
        }
        return false;
    }

    public InetUtils.HostInfo convertAddress(InetAddress address) {
        String hostname;
        InetUtils.HostInfo hostInfo = new InetUtils.HostInfo();
        Future<String> result = this.executorService.submit(address::getHostName);
        try {
            hostname = result.get(this.properties.getTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.log.info((Object)"Cannot determine local hostname");
            hostname = "localhost";
        }
        hostInfo.setHostname(hostname);
        hostInfo.setIpAddress(address.getHostAddress());
        return hostInfo;
    }
}

