/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.annotation.aspectj;

import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.annotation.aspectj.MethodWrapper;
import com.alibaba.csp.sentinel.annotation.aspectj.ResourceMetadataRegistry;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.util.MethodUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public abstract class AbstractSentinelAspectSupport {
    protected String getResourceName(String resourceName, Method method) {
        if (StringUtil.isNotBlank((String)resourceName)) {
            return resourceName;
        }
        return MethodUtil.resolveMethodName((Method)method);
    }

    protected Object handleBlockException(ProceedingJoinPoint pjp, SentinelResource annotation, BlockException ex) throws Exception {
        return this.handleBlockException(pjp, annotation.fallback(), annotation.blockHandler(), annotation.blockHandlerClass(), ex);
    }

    protected Object handleBlockException(ProceedingJoinPoint pjp, String fallback, String blockHandler, Class<?>[] blockHandlerClass, BlockException ex) throws Exception {
        Method method;
        Object[] originArgs = pjp.getArgs();
        if (this.isDegradeFailure(ex) && (method = this.extractFallbackMethod(pjp, fallback)) != null) {
            return method.invoke(pjp.getTarget(), originArgs);
        }
        Method blockHandlerMethod = this.extractBlockHandlerMethod(pjp, blockHandler, blockHandlerClass);
        if (blockHandlerMethod != null) {
            Object[] args = Arrays.copyOf(originArgs, originArgs.length + 1);
            args[args.length - 1] = ex;
            if (this.isStatic(blockHandlerMethod)) {
                return blockHandlerMethod.invoke(null, args);
            }
            return blockHandlerMethod.invoke(pjp.getTarget(), args);
        }
        throw ex;
    }

    protected void traceException(Throwable ex, SentinelResource annotation) {
        if (this.isTracedException(ex, annotation.exceptionsToTrace())) {
            Tracer.trace((Throwable)ex);
        }
    }

    private boolean isTracedException(Throwable ex, Class<? extends Throwable>[] exceptionsToTrace) {
        if (exceptionsToTrace == null) {
            return false;
        }
        for (Class<? extends Throwable> exceptionToTrace : exceptionsToTrace) {
            if (!exceptionToTrace.isAssignableFrom(ex.getClass())) continue;
            return true;
        }
        return false;
    }

    private boolean isDegradeFailure(BlockException ex) {
        return ex instanceof DegradeException;
    }

    private Method extractFallbackMethod(ProceedingJoinPoint pjp, String fallbackName) {
        if (StringUtil.isBlank((String)fallbackName)) {
            return null;
        }
        Class<?> clazz = pjp.getTarget().getClass();
        MethodWrapper m = ResourceMetadataRegistry.lookupFallback(clazz, fallbackName);
        if (m == null) {
            Method method = this.resolveFallbackInternal(pjp, fallbackName);
            ResourceMetadataRegistry.updateFallbackFor(clazz, fallbackName, method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method resolveFallbackInternal(ProceedingJoinPoint pjp, String name) {
        Method originMethod = this.resolveMethod(pjp);
        Class<?>[] parameterTypes = originMethod.getParameterTypes();
        return this.findMethod(false, pjp.getTarget().getClass(), name, originMethod.getReturnType(), parameterTypes);
    }

    private Method extractBlockHandlerMethod(ProceedingJoinPoint pjp, String name, Class<?>[] locationClass) {
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        boolean mustStatic = locationClass != null && locationClass.length >= 1;
        Class<?> clazz = mustStatic ? locationClass[0] : pjp.getTarget().getClass();
        MethodWrapper m = ResourceMetadataRegistry.lookupBlockHandler(clazz, name);
        if (m == null) {
            Method method = this.resolveBlockHandlerInternal(pjp, name, clazz, mustStatic);
            ResourceMetadataRegistry.updateBlockHandlerFor(clazz, name, method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method resolveBlockHandlerInternal(ProceedingJoinPoint pjp, String name, Class<?> clazz, boolean mustStatic) {
        Method originMethod = this.resolveMethod(pjp);
        Class<?>[] originList = originMethod.getParameterTypes();
        Class<?>[] parameterTypes = Arrays.copyOf(originList, originList.length + 1);
        parameterTypes[parameterTypes.length - 1] = BlockException.class;
        return this.findMethod(mustStatic, clazz, name, originMethod.getReturnType(), parameterTypes);
    }

    private boolean checkStatic(boolean mustStatic, Method method) {
        return !mustStatic || this.isStatic(method);
    }

    private Method findMethod(boolean mustStatic, Class<?> clazz, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!name.equals(method.getName()) || !this.checkStatic(mustStatic, method) || !returnType.isAssignableFrom(method.getReturnType()) || !Arrays.equals(parameterTypes, method.getParameterTypes())) continue;
            RecordLog.info((String)"Resolved method [{0}] in class [{1}]", (Object[])new Object[]{name, clazz.getCanonicalName()});
            return method;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            return this.findMethod(mustStatic, superClass, name, returnType, parameterTypes);
        }
        String methodType = mustStatic ? " static" : "";
        RecordLog.warn((String)"Cannot find{0} method [{1}] in class [{2}] with parameters {3}", (Object[])new Object[]{methodType, name, clazz.getCanonicalName(), Arrays.toString(parameterTypes)});
        return null;
    }

    private boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    protected Method resolveMethod(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Class<?> targetClass = joinPoint.getTarget().getClass();
        Method method = this.getDeclaredMethodFor(targetClass, signature.getName(), signature.getMethod().getParameterTypes());
        if (method == null) {
            throw new IllegalStateException("Cannot resolve target method: " + signature.getMethod().getName());
        }
        return method;
    }

    private Method getDeclaredMethodFor(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getDeclaredMethodFor(superClass, name, parameterTypes);
            }
            return null;
        }
    }
}

