/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.redis;

import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.redis.config.RedisConnectionConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslOptions;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import io.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import io.lettuce.core.cluster.pubsub.api.sync.RedisClusterPubSubCommands;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;

public class RedisDataSource<T>
extends AbstractDataSource<String, T> {
    private final RedisClient redisClient;
    private final RedisClusterClient redisClusterClient;
    private final String ruleKey;

    public RedisDataSource(RedisConnectionConfig connectionConfig, String ruleKey, String channel, Converter<String, T> parser) {
        super(parser);
        AssertUtil.notNull((Object)connectionConfig, (String)"Redis connection config can not be null");
        AssertUtil.notEmpty((String)ruleKey, (String)"Redis ruleKey can not be empty");
        AssertUtil.notEmpty((String)channel, (String)"Redis subscribe channel can not be empty");
        if (connectionConfig.getRedisClusters().size() == 0) {
            this.redisClient = this.getRedisClient(connectionConfig);
            this.redisClusterClient = null;
        } else {
            this.redisClusterClient = this.getRedisClusterClient(connectionConfig);
            this.redisClient = null;
        }
        this.ruleKey = ruleKey;
        this.loadInitialConfig();
        this.subscribeFromChannel(channel);
    }

    private SslOptions initSslOptions(RedisConnectionConfig connectionConfig) {
        if (!connectionConfig.isSslEnable()) {
            return null;
        }
        SslOptions.Builder sslOptionsBuilder = SslOptions.builder();
        if (connectionConfig.getTrustedCertificatesPath() != null) {
            if (connectionConfig.getTrustedCertificatesPath().endsWith(".jks")) {
                sslOptionsBuilder.truststore(new File(connectionConfig.getTrustedCertificatesPath()), connectionConfig.getTrustedCertificatesJksPassword());
            } else {
                sslOptionsBuilder.trustManager(new File(connectionConfig.getTrustedCertificatesPath()));
            }
        }
        if (connectionConfig.getKeyCertChainFilePath() != null || connectionConfig.getKeyFilePath() != null) {
            if (connectionConfig.getKeyFilePath().endsWith(".jks")) {
                sslOptionsBuilder.keystore(new File(connectionConfig.getKeyCertChainFilePath()), connectionConfig.getKeyFilePassword() == null ? null : connectionConfig.getKeyFilePassword().toCharArray());
            } else {
                sslOptionsBuilder.keyManager(new File(connectionConfig.getKeyCertChainFilePath()), new File(connectionConfig.getKeyFilePath()), connectionConfig.getKeyFilePassword() == null ? null : connectionConfig.getKeyFilePassword().toCharArray());
            }
        }
        return sslOptionsBuilder.build();
    }

    private RedisClient getRedisClient(RedisConnectionConfig connectionConfig) {
        RedisClient redisClient;
        if (connectionConfig.getRedisSentinels().size() == 0) {
            RecordLog.info((String)"[RedisDataSource] Creating stand-alone mode Redis client", (Object[])new Object[0]);
            redisClient = this.getRedisStandaloneClient(connectionConfig);
        } else {
            RecordLog.info((String)"[RedisDataSource] Creating Redis Sentinel mode Redis client", (Object[])new Object[0]);
            redisClient = this.getRedisSentinelClient(connectionConfig);
        }
        SslOptions sslOptions = this.initSslOptions(connectionConfig);
        if (sslOptions != null) {
            redisClient.setOptions((ClientOptions)ClusterClientOptions.builder().sslOptions(sslOptions).build());
        }
        return redisClient;
    }

    private RedisClusterClient getRedisClusterClient(RedisConnectionConfig connectionConfig) {
        char[] password = connectionConfig.getPassword();
        String clientName = connectionConfig.getClientName();
        ArrayList<RedisURI> redisUris = new ArrayList<RedisURI>();
        for (RedisConnectionConfig config : connectionConfig.getRedisClusters()) {
            RedisURI.Builder clusterRedisUriBuilder = RedisURI.builder();
            clusterRedisUriBuilder.withHost(config.getHost()).withPort(config.getPort()).withSsl(config.isSslEnable()).withTimeout(Duration.ofMillis(connectionConfig.getTimeout()));
            if (password != null) {
                clusterRedisUriBuilder.withPassword(connectionConfig.getPassword());
            }
            redisUris.add(clusterRedisUriBuilder.build());
        }
        RedisClusterClient redisClusterClient = RedisClusterClient.create(redisUris);
        SslOptions sslOptions = this.initSslOptions(connectionConfig);
        if (sslOptions != null) {
            redisClusterClient.setOptions(ClusterClientOptions.builder().sslOptions(sslOptions).build());
        }
        return redisClusterClient;
    }

    private RedisClient getRedisStandaloneClient(RedisConnectionConfig connectionConfig) {
        char[] password = connectionConfig.getPassword();
        String clientName = connectionConfig.getClientName();
        RedisURI.Builder redisUriBuilder = RedisURI.builder();
        redisUriBuilder.withHost(connectionConfig.getHost()).withPort(connectionConfig.getPort()).withDatabase(connectionConfig.getDatabase()).withSsl(connectionConfig.isSslEnable()).withTimeout(Duration.ofMillis(connectionConfig.getTimeout()));
        if (password != null) {
            redisUriBuilder.withPassword(connectionConfig.getPassword());
        }
        if (StringUtil.isNotEmpty((String)connectionConfig.getClientName())) {
            redisUriBuilder.withClientName(clientName);
        }
        return RedisClient.create((RedisURI)redisUriBuilder.build());
    }

    private RedisClient getRedisSentinelClient(RedisConnectionConfig connectionConfig) {
        char[] password = connectionConfig.getPassword();
        String clientName = connectionConfig.getClientName();
        RedisURI.Builder sentinelRedisUriBuilder = RedisURI.builder();
        for (RedisConnectionConfig config : connectionConfig.getRedisSentinels()) {
            sentinelRedisUriBuilder.withSentinel(config.getHost(), config.getPort());
        }
        if (password != null) {
            sentinelRedisUriBuilder.withPassword(connectionConfig.getPassword());
        }
        if (StringUtil.isNotEmpty((String)connectionConfig.getClientName())) {
            sentinelRedisUriBuilder.withClientName(clientName);
        }
        sentinelRedisUriBuilder.withSentinelMasterId(connectionConfig.getRedisSentinelMasterId()).withSsl(connectionConfig.isSslEnable()).withTimeout(Duration.ofMillis(connectionConfig.getTimeout()));
        return RedisClient.create((RedisURI)sentinelRedisUriBuilder.build());
    }

    private void subscribeFromChannel(String channel) {
        DelegatingRedisPubSubListener adapterListener = new DelegatingRedisPubSubListener();
        if (this.redisClient != null) {
            StatefulRedisPubSubConnection pubSubConnection = this.redisClient.connectPubSub();
            pubSubConnection.addListener((RedisPubSubListener)adapterListener);
            RedisPubSubCommands sync = pubSubConnection.sync();
            sync.subscribe((Object[])new String[]{channel});
        } else {
            StatefulRedisClusterPubSubConnection pubSubConnection = this.redisClusterClient.connectPubSub();
            pubSubConnection.addListener((RedisPubSubListener)adapterListener);
            RedisClusterPubSubCommands sync = pubSubConnection.sync();
            sync.subscribe((Object[])new String[]{channel});
        }
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"[RedisDataSource] WARN: initial config is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[RedisDataSource] Error when loading initial config", (Throwable)ex);
        }
    }

    public String readSource() {
        if (this.redisClient == null && this.redisClusterClient == null) {
            throw new IllegalStateException("Redis client or Redis Cluster client has not been initialized or error occurred");
        }
        if (this.redisClient != null) {
            RedisCommands stringRedisCommands = this.redisClient.connect().sync();
            return (String)stringRedisCommands.get((Object)this.ruleKey);
        }
        RedisAdvancedClusterCommands stringRedisCommands = this.redisClusterClient.connect().sync();
        return (String)stringRedisCommands.get((Object)this.ruleKey);
    }

    public void close() {
        if (this.redisClient != null) {
            this.redisClient.shutdown();
        } else {
            this.redisClusterClient.shutdown();
        }
    }

    private class DelegatingRedisPubSubListener
    extends RedisPubSubAdapter<String, String> {
        DelegatingRedisPubSubListener() {
        }

        public void message(String channel, String message) {
            RecordLog.info((String)"[RedisDataSource] New property value received for channel {}: {}", (Object[])new Object[]{channel, message});
            RedisDataSource.this.getProperty().updateValue(RedisDataSource.this.parser.convert((Object)message));
        }
    }
}

