/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.webflux;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.adapter.reactor.ContextConfig;
import com.alibaba.csp.sentinel.adapter.reactor.EntryConfig;
import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.WebFluxCallbackManager;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Optional;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class SentinelWebFluxFilter
implements WebFilter {
    private static final String EMPTY_ORIGIN = "";

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String path = exchange.getRequest().getPath().value();
        String finalPath = WebFluxCallbackManager.getUrlCleaner().apply(exchange, path);
        if (StringUtil.isEmpty((String)finalPath)) {
            return chain.filter(exchange);
        }
        return chain.filter(exchange).transform(this.buildSentinelTransformer(exchange, finalPath));
    }

    private SentinelReactorTransformer<Void> buildSentinelTransformer(ServerWebExchange exchange, String finalPath) {
        String origin = Optional.ofNullable(WebFluxCallbackManager.getRequestOriginParser()).map(f -> (String)f.apply(exchange)).orElse(EMPTY_ORIGIN);
        return new SentinelReactorTransformer(new EntryConfig(finalPath, 1, EntryType.IN, new ContextConfig(finalPath, origin)));
    }
}

