
package com.alibaba.edas.endpoint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.edas.ribbon.MigrationServer;
import com.alibaba.edas.ribbon.MigrationServerList;

import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

import static com.alibaba.edas.ribbon.ServerListMap.SERVER_LIST_MAP;

/**
 * @author xiaojing
 */
@Endpoint(id = "migration-server-list")
public class MigrationEndpoint2 {

    @ReadOperation
    public Map<String, Object> invoke() {

        Map<String, Object> result = new HashMap<>();

        for (Map.Entry<String, MigrationServerList> entry : SERVER_LIST_MAP.entrySet()) {

            String configName = entry.getKey();
            List<MigrationServer> serverList = entry.getValue().getServers();
            result.put(configName, serverList);
        }
        return result;
    }
}
