/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redis;

import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.redis.RedisCacheConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.Pool;

public class RedisCache<K, V>
extends AbstractExternalCache<K, V> {
    private RedisCacheConfig<K, V> config;
    Function<Object, byte[]> valueEncoder;
    Function<byte[], Object> valueDecoder;
    private Pool<Jedis> pool;

    public RedisCache(RedisCacheConfig<K, V> config) {
        super(config);
        this.config = config;
        this.pool = config.getJedisPool();
        this.valueEncoder = config.getValueEncoder();
        this.valueDecoder = config.getValueDecoder();
        if (this.pool == null) {
            throw new CacheConfigException("no pool");
        }
        if (config.isExpireAfterAccess()) {
            throw new CacheConfigException("expireAfterAccess is not supported");
        }
    }

    public CacheConfig<K, V> config() {
        return this.config;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.equals(Pool.class)) {
            return (T)this.pool;
        }
        if (clazz.equals(JedisPool.class)) {
            return (T)this.pool;
        }
        if (clazz.equals(JedisSentinelPool.class)) {
            return (T)this.pool;
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CacheGetResult<V> do_GET(K key) {
        if (key == null) {
            return new CacheGetResult(CacheResultCode.FAIL, "illegal argument", null);
        }
        try (Jedis jedis = (Jedis)this.pool.getResource();){
            byte[] newKey = this.buildKey(key);
            byte[] bytes = jedis.get(newKey);
            if (bytes != null) {
                CacheValueHolder holder = (CacheValueHolder)this.valueDecoder.apply(bytes);
                if (System.currentTimeMillis() >= holder.getExpireTime()) {
                    CacheGetResult cacheGetResult = CacheGetResult.EXPIRED_WITHOUT_MSG;
                    return cacheGetResult;
                }
                CacheGetResult cacheGetResult = new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
                return cacheGetResult;
            }
            CacheGetResult cacheGetResult = CacheGetResult.NOT_EXISTS_WITHOUT_MSG;
            return cacheGetResult;
        }
        catch (Exception ex) {
            this.logError("GET", key, ex);
            return new CacheGetResult((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MultiGetResult<K, V> do_GET_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return new MultiGetResult(CacheResultCode.FAIL, "illegal argument", null);
        }
        try (Jedis jedis = (Jedis)this.pool.getResource();){
            ArrayList<K> keyList = new ArrayList<K>(keys);
            byte[][] newKeys = (byte[][])keyList.stream().map(k -> this.buildKey(k)).toArray(x$0 -> new byte[x$0][]);
            HashMap<K, CacheGetResult> resultMap = new HashMap<K, CacheGetResult>();
            if (newKeys.length > 0) {
                List mgetResults = jedis.mget(newKeys);
                for (int i = 0; i < mgetResults.size(); ++i) {
                    Object value = mgetResults.get(i);
                    K key = keyList.get(i);
                    if (value != null) {
                        CacheValueHolder holder = (CacheValueHolder)this.valueDecoder.apply((byte[])value);
                        if (System.currentTimeMillis() >= holder.getExpireTime()) {
                            resultMap.put(key, CacheGetResult.EXPIRED_WITHOUT_MSG);
                            continue;
                        }
                        CacheGetResult r = new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
                        resultMap.put(key, r);
                        continue;
                    }
                    resultMap.put(key, CacheGetResult.NOT_EXISTS_WITHOUT_MSG);
                }
            }
            MultiGetResult multiGetResult = new MultiGetResult(CacheResultCode.SUCCESS, null, resultMap);
            return multiGetResult;
        }
        catch (Exception ex) {
            this.logError("GET_ALL", "keys(" + keys.size() + ")", ex);
            return new MultiGetResult((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CacheResult do_PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        try (Jedis jedis = (Jedis)this.pool.getResource();){
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            byte[] newKey = this.buildKey(key);
            String rt = jedis.psetex(newKey, timeUnit.toMillis(expireAfterWrite), this.valueEncoder.apply(holder));
            if ("OK".equals(rt)) {
                CacheResult cacheResult2 = CacheResult.SUCCESS_WITHOUT_MSG;
                return cacheResult2;
            }
            CacheResult cacheResult = new CacheResult(CacheResultCode.FAIL, rt);
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("PUT", key, ex);
            return new CacheResult((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CacheResult do_PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        if (map == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        try (Jedis jedis = (Jedis)this.pool.getResource();){
            int failCount = 0;
            ArrayList<Response> responses = new ArrayList<Response>();
            Pipeline p = jedis.pipelined();
            for (Map.Entry<K, V> en : map.entrySet()) {
                CacheValueHolder holder = new CacheValueHolder(en.getValue(), timeUnit.toMillis(expireAfterWrite));
                Response resp = p.psetex(this.buildKey(en.getKey()), timeUnit.toMillis(expireAfterWrite), this.valueEncoder.apply(holder));
                responses.add(resp);
            }
            p.sync();
            for (Response resp : responses) {
                if ("OK".equals(resp.get())) continue;
                ++failCount;
            }
            Iterator<Map.Entry<K, V>> iterator = failCount == 0 ? CacheResult.SUCCESS_WITHOUT_MSG : (failCount == map.size() ? CacheResult.FAIL_WITHOUT_MSG : CacheResult.PART_SUCCESS_WITHOUT_MSG);
            return iterator;
        }
        catch (Exception ex) {
            this.logError("PUT_ALL", "map(" + map.size() + ")", ex);
            return new CacheResult((Throwable)ex);
        }
    }

    protected CacheResult do_REMOVE(K key) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        return this.REMOVE_impl(key, this.buildKey(key));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CacheResult REMOVE_impl(Object key, byte[] newKey) {
        try (Jedis jedis = (Jedis)this.pool.getResource();){
            Long rt = jedis.del(newKey);
            if (rt == null) {
                CacheResult cacheResult = CacheResult.FAIL_WITHOUT_MSG;
                return cacheResult;
            }
            if (rt == 1L) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                return cacheResult;
            }
            if (rt == 0L) {
                CacheResult cacheResult = new CacheResult(CacheResultCode.NOT_EXISTS, null);
                return cacheResult;
            }
            CacheResult cacheResult = CacheResult.FAIL_WITHOUT_MSG;
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("REMOVE", key, ex);
            return new CacheResult((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CacheResult do_REMOVE_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        try (Jedis jedis = (Jedis)this.pool.getResource();){
            byte[][] newKeys = (byte[][])keys.stream().map(k -> this.buildKey(k)).toArray(len -> new byte[keys.size()][]);
            jedis.del(newKeys);
            CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("REMOVE_ALL", "keys(" + keys.size() + ")", ex);
            return new CacheResult((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CacheResult do_PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        try (Jedis jedis = (Jedis)this.pool.getResource();){
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            byte[] newKey = this.buildKey(key);
            String rt = jedis.set(newKey, this.valueEncoder.apply(holder), "NX".getBytes(), "PX".getBytes(), timeUnit.toMillis(expireAfterWrite));
            if ("OK".equals(rt)) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                return cacheResult;
            }
            if (rt == null) {
                CacheResult cacheResult = CacheResult.EXISTS_WITHOUT_MSG;
                return cacheResult;
            }
            CacheResult cacheResult = new CacheResult(CacheResultCode.FAIL, rt);
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("PUT_IF_ABSENT", key, ex);
            return new CacheResult((Throwable)ex);
        }
    }

    protected boolean needLogStackTrace(Throwable e) {
        return !(e instanceof JedisConnectionException);
    }
}

