/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.zfile;

import com.android.apkzlib.zfile.ApkCreator;
import com.android.apkzlib.zfile.ApkCreatorFactory;
import com.android.apkzlib.zfile.ZFiles;
import com.android.apkzlib.zip.AlignmentRule;
import com.android.apkzlib.zip.AlignmentRules;
import com.android.apkzlib.zip.StoredEntry;
import com.android.apkzlib.zip.ZFile;
import com.android.apkzlib.zip.ZFileOptions;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ApkZFileCreator
implements ApkCreator {
    private static final String NATIVE_LIBRARIES_SUFFIX = ".so";
    private static final AlignmentRule SO_RULE = AlignmentRules.constantForSuffix(".so", 4096);
    @Nonnull
    private final ZFile mZip;
    private boolean mClosed;
    @Nonnull
    private final Predicate<String> mNoCompressPredicate;

    ApkZFileCreator(@Nonnull ApkCreatorFactory.CreationData creationData, @Nonnull ZFileOptions options) throws IOException {
        switch (creationData.getNativeLibrariesPackagingMode()) {
            case COMPRESSED: {
                this.mNoCompressPredicate = creationData.getNoCompressPredicate();
                break;
            }
            case UNCOMPRESSED_AND_ALIGNED: {
                this.mNoCompressPredicate = creationData.getNoCompressPredicate().or(name -> name.endsWith(NATIVE_LIBRARIES_SUFFIX));
                options.setAlignmentRule(AlignmentRules.compose(SO_RULE, options.getAlignmentRule()));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.mZip = ZFiles.apk(creationData.getApkPath(), options, creationData.getPrivateKey(), creationData.getCertificate(), creationData.isV1SigningEnabled(), creationData.isV2SigningEnabled(), creationData.getBuiltBy(), creationData.getCreatedBy(), creationData.getMinSdkVersion());
        this.mClosed = false;
    }

    @Override
    public void writeZip(@Nonnull File zip, @Nullable Function<String, String> transform, @Nullable Predicate<String> isIgnored) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"mClosed == true");
        Preconditions.checkArgument((boolean)zip.isFile(), (Object)"!zip.isFile()");
        try (Closer closer = Closer.create();){
            ZFile toMerge = (ZFile)closer.register((Closeable)new ZFile(zip));
            Predicate<String> predicate = isIgnored == null ? s -> false : isIgnored;
            this.mZip.mergeFrom(toMerge, predicate);
        }
    }

    @Override
    public void writeFile(@Nonnull File inputFile, @Nonnull String apkPath) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"mClosed == true");
        boolean mayCompress = !this.mNoCompressPredicate.test(apkPath);
        try (Closer closer = Closer.create();){
            FileInputStream inputFileStream = (FileInputStream)closer.register((Closeable)new FileInputStream(inputFile));
            this.mZip.add(apkPath, inputFileStream, mayCompress);
        }
    }

    @Override
    public void deleteFile(@Nonnull String apkPath) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"mClosed == true");
        StoredEntry entry = this.mZip.get(apkPath);
        if (entry != null) {
            entry.delete();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mZip.close();
        this.mClosed = true;
    }
}

