/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.zip;

import com.android.apkzlib.zip.CentralDirectoryHeaderCompressInfo;
import com.android.apkzlib.zip.EncodeUtils;
import com.android.apkzlib.zip.ExtraField;
import com.android.apkzlib.zip.GPFlags;
import com.android.apkzlib.zip.ZFile;
import com.android.apkzlib.zip.utils.MsDosDateTimeUtils;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;

public class CentralDirectoryHeader
implements Cloneable {
    private static final int DEFAULT_VERSION_MADE_BY = 24;
    @Nonnull
    private String mName;
    private long mCrc32;
    private long mUncompressedSize;
    private long mMadeBy;
    @Nonnull
    private GPFlags mGpBit;
    private long mLastModTime;
    private long mLastModDate;
    @Nonnull
    private ExtraField mExtraField;
    @Nonnull
    private byte[] mComment;
    private long mInternalAttributes;
    private long mExternalAttributes;
    private long mOffset;
    private byte[] mEncodedFileName;
    @Nonnull
    private Future<CentralDirectoryHeaderCompressInfo> mCompressInfo;
    @Nonnull
    private final ZFile mFile;

    CentralDirectoryHeader(@Nonnull String name, long uncompressedSize, @Nonnull Future<CentralDirectoryHeaderCompressInfo> compressInfo, @Nonnull GPFlags flags, @Nonnull ZFile zFile) {
        this.mName = name;
        this.mUncompressedSize = uncompressedSize;
        this.mCrc32 = 0L;
        this.mMadeBy = 24L;
        this.mGpBit = flags;
        this.mLastModTime = MsDosDateTimeUtils.packCurrentTime();
        this.mLastModDate = MsDosDateTimeUtils.packCurrentDate();
        this.mExtraField = new ExtraField();
        this.mComment = new byte[0];
        this.mInternalAttributes = 0L;
        this.mExternalAttributes = 0L;
        this.mOffset = -1L;
        this.mEncodedFileName = EncodeUtils.encode(name, this.mGpBit);
        this.mCompressInfo = compressInfo;
        this.mFile = zFile;
    }

    @Nonnull
    public String getName() {
        return this.mName;
    }

    public long getUncompressedSize() {
        return this.mUncompressedSize;
    }

    public long getCrc32() {
        return this.mCrc32;
    }

    void setCrc32(long crc32) {
        this.mCrc32 = crc32;
    }

    public long getMadeBy() {
        return this.mMadeBy;
    }

    void setMadeBy(long madeBy) {
        this.mMadeBy = madeBy;
    }

    @Nonnull
    public GPFlags getGpBit() {
        return this.mGpBit;
    }

    public long getLastModTime() {
        return this.mLastModTime;
    }

    void setLastModTime(long lastModTime) {
        this.mLastModTime = lastModTime;
    }

    public long getLastModDate() {
        return this.mLastModDate;
    }

    void setLastModDate(long lastModDate) {
        this.mLastModDate = lastModDate;
    }

    @Nonnull
    public ExtraField getExtraField() {
        return this.mExtraField;
    }

    public void setExtraField(@Nonnull ExtraField extraField) {
        this.setExtraFieldNoNotify(extraField);
        this.mFile.centralDirectoryChanged();
    }

    void setExtraFieldNoNotify(@Nonnull ExtraField extraField) {
        this.mExtraField = extraField;
    }

    @Nonnull
    public byte[] getComment() {
        return this.mComment;
    }

    void setComment(@Nonnull byte[] comment) {
        this.mComment = comment;
    }

    public long getInternalAttributes() {
        return this.mInternalAttributes;
    }

    void setInternalAttributes(long internalAttributes) {
        this.mInternalAttributes = internalAttributes;
    }

    public long getExternalAttributes() {
        return this.mExternalAttributes;
    }

    void setExternalAttributes(long externalAttributes) {
        this.mExternalAttributes = externalAttributes;
    }

    public long getOffset() {
        return this.mOffset;
    }

    void setOffset(long offset) {
        this.mOffset = offset;
    }

    public byte[] getEncodedFileName() {
        return this.mEncodedFileName;
    }

    void resetDeferredCrc() {
        this.mGpBit = GPFlags.make(this.mGpBit.isUtf8FileName());
    }

    protected CentralDirectoryHeader clone() throws CloneNotSupportedException {
        CentralDirectoryHeader cdr = (CentralDirectoryHeader)super.clone();
        cdr.mExtraField = this.mExtraField;
        cdr.mComment = Arrays.copyOf(this.mComment, this.mComment.length);
        cdr.mEncodedFileName = Arrays.copyOf(this.mEncodedFileName, this.mEncodedFileName.length);
        return cdr;
    }

    @Nonnull
    public Future<CentralDirectoryHeaderCompressInfo> getCompressionInfo() {
        return this.mCompressInfo;
    }

    @Nonnull
    public CentralDirectoryHeaderCompressInfo getCompressionInfoWithWait() throws IOException {
        try {
            CentralDirectoryHeaderCompressInfo info = this.getCompressionInfo().get();
            Verify.verifyNotNull((Object)info, (String)"info == null", (Object[])new Object[0]);
            return info;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for compression information.", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Execution of compression failed.", e);
        }
    }
}

