/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.cap;

import com.basho.riak.client.api.cap.ConflictResolver;
import com.basho.riak.client.api.cap.DefaultResolver;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ConflictResolverFactory {
    INSTANCE;

    private final Map<Type, ConflictResolver<?>> resolverInstances = new ConcurrentHashMap();

    public static ConflictResolverFactory getInstance() {
        return INSTANCE;
    }

    public <T> ConflictResolver<T> getConflictResolver(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        return this.getConflictResolver(clazz, null);
    }

    public <T> ConflictResolver<T> getConflictResolver(TypeReference<T> typeReference) {
        if (typeReference == null) {
            throw new IllegalArgumentException("typeReference cannot be null");
        }
        return this.getConflictResolver(null, typeReference);
    }

    private <T> ConflictResolver<T> getConflictResolver(Type type, TypeReference<T> typeReference) {
        ConflictResolver<?> resolver = this.resolverInstances.get(type = type != null ? type : typeReference.getType());
        if (resolver == null) {
            resolver = new DefaultResolver();
        }
        return resolver;
    }

    public <T> void registerConflictResolver(Class<T> clazz, ConflictResolver<T> resolver) {
        this.resolverInstances.put(clazz, resolver);
    }

    public <T> void registerConflictResolver(TypeReference<T> typeReference, ConflictResolver<T> resolver) {
        this.resolverInstances.put(typeReference.getType(), resolver);
    }

    public <T> void unregisterConflictResolver(Class<T> clazz) {
        this.resolverInstances.remove(clazz);
    }

    public <T> void unregisterConflictResolver(TypeReference<T> typeReference) {
        this.resolverInstances.remove(typeReference.getType());
    }
}

