/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.cap;

public final class Quorum {
    public static final String ONE = "one";
    public static final String QUORUM = "quorum";
    public static final String ALL = "all";
    public static final String DEFAULT = "default";
    private final int i;

    public Quorum(int i) {
        if (i < -5 || i == -1) {
            throw new IllegalArgumentException("Illegal value for quorum: " + i);
        }
        this.i = i;
    }

    public static Quorum oneQuorum() {
        return new Quorum(-2);
    }

    public static Quorum quorumQuorum() {
        return new Quorum(-3);
    }

    public static Quorum allQuorum() {
        return new Quorum(-4);
    }

    public static Quorum defaultQuorum() {
        return new Quorum(-5);
    }

    public boolean isSymbolic() {
        switch (this.i) {
            case -5: 
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public int getIntValue() {
        return this.i;
    }

    public String toString() {
        String quorum = null;
        if (this.i > 0) {
            quorum = Integer.toString(this.i);
        } else {
            switch (this.i) {
                case -2: {
                    quorum = ONE;
                    break;
                }
                case -3: {
                    quorum = QUORUM;
                    break;
                }
                case -4: {
                    quorum = ALL;
                    break;
                }
                case -5: {
                    quorum = DEFAULT;
                    break;
                }
            }
        }
        return quorum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.i;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Quorum)) {
            return false;
        }
        Quorum other = (Quorum)obj;
        return this.i == other.i;
    }
}

