/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.datatypes;

import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.api.commands.datatypes.Context;
import com.basho.riak.client.api.commands.datatypes.FetchDatatype;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.operations.DtFetchOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.crdt.types.RiakCounter;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;

public final class FetchCounter
extends FetchDatatype<RiakCounter, Response, Location> {
    private FetchCounter(Builder builder) {
        super(builder);
    }

    @Override
    protected final RiakFuture<Response, Location> executeAsync(RiakCluster cluster) {
        RiakFuture<DtFetchOperation.Response, Location> coreFuture = cluster.execute(this.buildCoreOperation());
        CoreFutureAdapter<Response, Location, DtFetchOperation.Response, Location> future = new CoreFutureAdapter<Response, Location, DtFetchOperation.Response, Location>(coreFuture){

            @Override
            protected Response convertResponse(DtFetchOperation.Response coreResponse) {
                RiakDatatype element = coreResponse.getCrdtElement();
                Context context = null;
                if (coreResponse.hasContext()) {
                    context = new Context(coreResponse.getContext());
                }
                RiakCounter datatype = FetchCounter.this.extractDatatype(element);
                return new Response(datatype, context);
            }

            @Override
            protected Location convertQueryInfo(Location coreQueryInfo) {
                return coreQueryInfo;
            }
        };
        coreFuture.addListener((RiakFutureListener<DtFetchOperation.Response, Location>)future);
        return future;
    }

    @Override
    public RiakCounter extractDatatype(RiakDatatype element) {
        return element.getAsCounter();
    }

    public static class Response
    extends FetchDatatype.Response<RiakCounter> {
        Response(RiakCounter counter, Context context) {
            super(counter, context);
        }
    }

    public static class Builder
    extends FetchDatatype.Builder<Builder> {
        public Builder(Location location) {
            super(location);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public FetchCounter build() {
            return new FetchCounter(this);
        }
    }
}

