/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.datatypes;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.api.cap.Quorum;
import com.basho.riak.client.api.commands.RiakOption;
import com.basho.riak.client.api.commands.datatypes.Context;
import com.basho.riak.client.core.operations.DtFetchOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import java.util.HashMap;
import java.util.Map;

public abstract class FetchDatatype<T extends RiakDatatype, S, U>
extends RiakCommand<S, U> {
    private final Location location;
    private final Map<Option<?>, Object> options = new HashMap();

    public Location getLocation() {
        return this.location;
    }

    protected FetchDatatype(Builder builder) {
        this.location = builder.location;
        this.options.putAll(builder.options);
    }

    public <V> FetchDatatype<T, S, U> withOption(Option<V> option, V value) {
        this.options.put(option, value);
        return this;
    }

    public abstract T extractDatatype(RiakDatatype var1);

    protected final DtFetchOperation buildCoreOperation() {
        DtFetchOperation.Builder builder = new DtFetchOperation.Builder(this.location);
        for (Map.Entry<Option<?>, Object> entry : this.options.entrySet()) {
            if (entry.getKey() == Option.R) {
                builder.withR(((Quorum)entry.getValue()).getIntValue());
                continue;
            }
            if (entry.getKey() == Option.PR) {
                builder.withPr(((Quorum)entry.getValue()).getIntValue());
                continue;
            }
            if (entry.getKey() == Option.BASIC_QUORUM) {
                builder.withBasicQuorum((Boolean)entry.getValue());
                continue;
            }
            if (entry.getKey() == Option.NOTFOUND_OK) {
                builder.withNotFoundOK((Boolean)entry.getValue());
                continue;
            }
            if (entry.getKey() == Option.TIMEOUT) {
                builder.withTimeout((Integer)entry.getValue());
                continue;
            }
            if (entry.getKey() == Option.SLOPPY_QUORUM) {
                builder.withSloppyQuorum((Boolean)entry.getValue());
                continue;
            }
            if (entry.getKey() == Option.N_VAL) {
                builder.withNVal((Integer)entry.getValue());
                continue;
            }
            if (entry.getKey() != Option.INCLUDE_CONTEXT) continue;
            builder.includeContext((Boolean)entry.getValue());
        }
        return builder.build();
    }

    public static class Response<T extends RiakDatatype> {
        private final T datatype;
        private final Context context;

        protected Response(T datatype, Context context) {
            this.datatype = datatype;
            this.context = context;
        }

        public T getDatatype() {
            return this.datatype;
        }

        public boolean hasContext() {
            return this.context != null;
        }

        public Context getContext() {
            return this.context;
        }
    }

    protected static abstract class Builder<T extends Builder<T>> {
        private final Location location;
        private final Map<Option<?>, Object> options = new HashMap();

        protected Builder(Location location) {
            if (location == null) {
                throw new IllegalArgumentException("Location cannot be null");
            }
            this.location = location;
        }

        public T withTimeout(int timeout) {
            return this.withOption(Option.TIMEOUT, timeout);
        }

        public <U> T withOption(Option<U> option, U value) {
            this.options.put(option, value);
            return this.self();
        }

        protected abstract T self();
    }

    public static final class Option<T>
    extends RiakOption<T> {
        public static final Option<Quorum> R = new Option("R");
        public static final Option<Quorum> PR = new Option("PR");
        public static final Option<Boolean> BASIC_QUORUM = new Option("BASIC_QUORUM");
        public static final Option<Boolean> NOTFOUND_OK = new Option("NOTFOUND_OK");
        public static final Option<Integer> TIMEOUT = new Option("TIMEOUT");
        public static final Option<Boolean> SLOPPY_QUORUM = new Option("SLOPPY_QUORUM");
        public static final Option<Integer> N_VAL = new Option("N_VAL");
        public static final Option<Boolean> INCLUDE_CONTEXT = new Option("INCLUDE_CONTEXT");

        public Option(String name) {
            super(name);
        }
    }
}

