/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.datatypes;

import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.api.commands.datatypes.Context;
import com.basho.riak.client.api.commands.datatypes.CounterUpdate;
import com.basho.riak.client.api.commands.datatypes.UpdateDatatype;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.operations.DtUpdateOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.crdt.types.RiakCounter;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.util.BinaryValue;

public class UpdateCounter
extends UpdateDatatype<RiakCounter, Response, Location> {
    private final CounterUpdate update;

    private UpdateCounter(Builder builder) {
        super(builder);
        this.update = builder.update;
    }

    @Override
    protected RiakFuture<Response, Location> executeAsync(RiakCluster cluster) {
        RiakFuture<DtUpdateOperation.Response, Location> coreFuture = cluster.execute(this.buildCoreOperation(this.update));
        CoreFutureAdapter<Response, Location, DtUpdateOperation.Response, Location> future = new CoreFutureAdapter<Response, Location, DtUpdateOperation.Response, Location>(coreFuture){

            @Override
            protected Response convertResponse(DtUpdateOperation.Response coreResponse) {
                RiakCounter counter = null;
                if (coreResponse.hasCrdtElement()) {
                    RiakDatatype element = coreResponse.getCrdtElement();
                    counter = element.getAsCounter();
                }
                BinaryValue returnedKey = coreResponse.hasGeneratedKey() ? coreResponse.getGeneratedKey() : null;
                Context returnedCtx = null;
                if (coreResponse.hasContext()) {
                    returnedCtx = new Context(coreResponse.getContext());
                }
                return new Response(returnedCtx, counter, returnedKey);
            }

            @Override
            protected Location convertQueryInfo(Location coreQueryInfo) {
                return coreQueryInfo;
            }
        };
        coreFuture.addListener((RiakFutureListener<DtUpdateOperation.Response, Location>)future);
        return future;
    }

    public static final class Builder
    extends UpdateDatatype.Builder<Builder> {
        private final CounterUpdate update;

        public Builder(Location location, CounterUpdate update) {
            super(location);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
            this.update = update;
        }

        public Builder(Namespace namespace, CounterUpdate update) {
            super(namespace);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
            this.update = update;
        }

        @Override
        public UpdateCounter build() {
            return new UpdateCounter(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static final class Response
    extends UpdateDatatype.Response<RiakCounter> {
        private Response(Context context, RiakCounter datatype, BinaryValue generatedKey) {
            super(context, datatype, generatedKey);
        }
    }
}

