/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.indexes;

import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.api.commands.indexes.SecondaryIndexQuery;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.operations.SecondaryIndexQueryOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.ArrayList;
import java.util.List;

public class RawIndexQuery
extends SecondaryIndexQuery<BinaryValue, Response, RawIndexQuery> {
    private final SecondaryIndexQuery.IndexConverter<BinaryValue> converter = new SecondaryIndexQuery.IndexConverter<BinaryValue>(){

        @Override
        public BinaryValue convert(BinaryValue input) {
            return input;
        }
    };

    protected RawIndexQuery(SecondaryIndexQuery.Init<BinaryValue, ?> builder) {
        super(builder);
    }

    @Override
    protected SecondaryIndexQuery.IndexConverter<BinaryValue> getConverter() {
        return this.converter;
    }

    @Override
    protected RiakFuture<Response, RawIndexQuery> executeAsync(RiakCluster cluster) {
        RiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture = this.executeCoreAsync(cluster);
        RawQueryFuture future = new RawQueryFuture(coreFuture);
        coreFuture.addListener(future);
        return future;
    }

    public static class Response
    extends SecondaryIndexQuery.Response<BinaryValue> {
        protected Response(Namespace queryLocation, SecondaryIndexQueryOperation.Response coreResponse, SecondaryIndexQuery.IndexConverter<BinaryValue> converter) {
            super(queryLocation, coreResponse, converter);
        }

        @Override
        public List<Entry> getEntries() {
            ArrayList<Entry> convertedList = new ArrayList<Entry>();
            for (SecondaryIndexQueryOperation.Response.Entry e : this.coreResponse.getEntryList()) {
                Location loc = this.getLocationFromCoreEntry(e);
                Entry ce = new Entry(loc, e.getIndexKey(), this.converter);
                convertedList.add(ce);
            }
            return convertedList;
        }

        public class Entry
        extends SecondaryIndexQuery.Response.Entry<BinaryValue> {
            protected Entry(Location riakObjectLocation, BinaryValue indexKey, SecondaryIndexQuery.IndexConverter<BinaryValue> converter) {
                super(riakObjectLocation, indexKey, converter);
            }
        }
    }

    public static class Builder
    extends SecondaryIndexQuery.Init<BinaryValue, Builder> {
        public Builder(Namespace namespace, String indexName, SecondaryIndexQuery.Type type, BinaryValue start, BinaryValue end) {
            super(namespace, indexName + (Object)((Object)type), start, end);
        }

        public Builder(Namespace namespace, String indexName, SecondaryIndexQuery.Type type, BinaryValue match) {
            super(namespace, indexName + (Object)((Object)type), match);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public RawIndexQuery build() {
            return new RawIndexQuery(this);
        }
    }

    protected final class RawQueryFuture
    extends CoreFutureAdapter<Response, RawIndexQuery, SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> {
        public RawQueryFuture(RiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture) {
            super(coreFuture);
        }

        @Override
        protected Response convertResponse(SecondaryIndexQueryOperation.Response coreResponse) {
            return new Response(RawIndexQuery.this.namespace, coreResponse, RawIndexQuery.this.converter);
        }

        @Override
        protected RawIndexQuery convertQueryInfo(SecondaryIndexQueryOperation.Query coreQueryInfo) {
            return RawIndexQuery.this;
        }
    }
}

