/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.kv;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.api.cap.Quorum;
import com.basho.riak.client.api.cap.VClock;
import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.api.commands.RiakOption;
import com.basho.riak.client.api.commands.kv.KvResponseBase;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.operations.FetchOperation;
import com.basho.riak.client.core.query.Location;
import java.util.HashMap;
import java.util.Map;

public final class FetchValue
extends RiakCommand<Response, Location> {
    private final Location location;
    private final Map<Option<?>, Object> options = new HashMap();

    FetchValue(Builder builder) {
        this.location = builder.location;
        this.options.putAll(builder.options);
    }

    @Override
    protected final RiakFuture<Response, Location> executeAsync(RiakCluster cluster) {
        RiakFuture<FetchOperation.Response, Location> coreFuture = cluster.execute(this.buildCoreOperation());
        CoreFutureAdapter<Response, Location, FetchOperation.Response, Location> future = new CoreFutureAdapter<Response, Location, FetchOperation.Response, Location>(coreFuture){

            @Override
            protected Response convertResponse(FetchOperation.Response coreResponse) {
                return ((Response.Builder)((Response.Builder)((Response.Builder)((Response.Builder)new Response.Builder().withNotFound(coreResponse.isNotFound())).withUnchanged(coreResponse.isUnchanged())).withValues(coreResponse.getObjectList())).withLocation(FetchValue.this.location)).build();
            }

            @Override
            protected Location convertQueryInfo(Location coreQueryInfo) {
                return coreQueryInfo;
            }
        };
        coreFuture.addListener((RiakFutureListener<FetchOperation.Response, Location>)future);
        return future;
    }

    private FetchOperation buildCoreOperation() {
        FetchOperation.Builder builder = new FetchOperation.Builder(this.location);
        for (Map.Entry<Option<?>, Object> opPair : this.options.entrySet()) {
            RiakOption option = opPair.getKey();
            if (option == Option.R) {
                builder.withR(((Quorum)opPair.getValue()).getIntValue());
                continue;
            }
            if (option == Option.DELETED_VCLOCK) {
                builder.withReturnDeletedVClock((Boolean)opPair.getValue());
                continue;
            }
            if (option == Option.TIMEOUT) {
                builder.withTimeout((Integer)opPair.getValue());
                continue;
            }
            if (option == Option.HEAD) {
                builder.withHeadOnly((Boolean)opPair.getValue());
                continue;
            }
            if (option == Option.BASIC_QUORUM) {
                builder.withBasicQuorum((Boolean)opPair.getValue());
                continue;
            }
            if (option == Option.IF_MODIFIED) {
                VClock clock = (VClock)opPair.getValue();
                builder.withIfNotModified(clock.getBytes());
                continue;
            }
            if (option == Option.N_VAL) {
                builder.withNVal((Integer)opPair.getValue());
                continue;
            }
            if (option == Option.PR) {
                builder.withPr(((Quorum)opPair.getValue()).getIntValue());
                continue;
            }
            if (option == Option.SLOPPY_QUORUM) {
                builder.withSloppyQuorum((Boolean)opPair.getValue());
                continue;
            }
            if (option != Option.NOTFOUND_OK) continue;
            builder.withNotFoundOK((Boolean)opPair.getValue());
        }
        return builder.build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + this.options.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FetchValue)) {
            return false;
        }
        FetchValue other = (FetchValue)obj;
        if (!(this.location == other.location || this.location != null && this.location.equals(other.location))) {
            return false;
        }
        return this.options == other.options || this.options != null && this.options.equals(other.options);
    }

    public String toString() {
        return String.format("{location: %s, options: %s}", this.location, this.options);
    }

    public static class Builder {
        private final Location location;
        private final Map<Option<?>, Object> options = new HashMap();

        public Builder(Location location) {
            if (location == null) {
                throw new IllegalArgumentException("Location cannot be null");
            }
            this.location = location;
        }

        public <U> Builder withOption(Option<U> option, U value) {
            this.options.put(option, value);
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.withOption(Option.TIMEOUT, timeout);
            return this;
        }

        public FetchValue build() {
            return new FetchValue(this);
        }
    }

    public static final class Option<T>
    extends RiakOption<T> {
        public static final Option<Quorum> R = new Option("R");
        public static final Option<Quorum> PR = new Option("PR");
        public static final Option<Boolean> BASIC_QUORUM = new Option("BASIC_QUORUM");
        public static final Option<Boolean> NOTFOUND_OK = new Option("NOTFOUND_OK");
        public static final Option<VClock> IF_MODIFIED = new Option("IF_MODIFIED");
        public static final Option<Boolean> HEAD = new Option("HEAD");
        public static final Option<Boolean> DELETED_VCLOCK = new Option("DELETED_VCLOCK");
        public static final Option<Integer> TIMEOUT = new Option("TIMEOUT");
        public static final Option<Boolean> SLOPPY_QUORUM = new Option("SLOPPY_QUORUM");
        public static final Option<Integer> N_VAL = new Option("N_VAL");

        private Option(String name) {
            super(name);
        }
    }

    public static class Response
    extends KvResponseBase {
        private final boolean notFound;
        private final boolean unchanged;

        Response(Init<?> builder) {
            super(builder);
            this.notFound = ((Init)builder).notFound;
            this.unchanged = ((Init)builder).unchanged;
        }

        public boolean isNotFound() {
            return this.notFound;
        }

        public boolean isUnchanged() {
            return this.unchanged;
        }

        static class Builder
        extends Init<Builder> {
            Builder() {
            }

            @Override
            protected Builder self() {
                return this;
            }

            @Override
            Response build() {
                return new Response(this);
            }
        }

        protected static abstract class Init<T extends Init<T>>
        extends KvResponseBase.Init<T> {
            private boolean notFound;
            private boolean unchanged;

            protected Init() {
            }

            T withUnchanged(boolean unchanged) {
                this.unchanged = unchanged;
                return (T)((Init)this.self());
            }

            T withNotFound(boolean notFound) {
                this.notFound = notFound;
                return (T)((Init)this.self());
            }
        }
    }
}

