/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.kv;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.api.commands.ListenableFuture;
import com.basho.riak.client.api.commands.kv.FetchValue;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.query.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class MultiFetch
extends RiakCommand<Response, List<Location>> {
    public static final int DEFAULT_MAX_IN_FLIGHT = 10;
    private final ArrayList<Location> locations = new ArrayList();
    private final Map<FetchValue.Option<?>, Object> options = new HashMap();
    private final int maxInFlight;

    private MultiFetch(Builder builder) {
        this.locations.addAll(builder.keys);
        this.options.putAll(builder.options);
        this.maxInFlight = builder.maxInFlight;
    }

    @Override
    protected RiakFuture<Response, List<Location>> executeAsync(RiakCluster cluster) {
        List<FetchValue> fetchOperations = this.buildFetchOperations();
        MultiFetchFuture future = new MultiFetchFuture(this.locations);
        Submitter submitter = new Submitter(fetchOperations, this.maxInFlight, cluster, future);
        Thread t = new Thread(submitter);
        t.setDaemon(true);
        t.start();
        return future;
    }

    private List<FetchValue> buildFetchOperations() {
        LinkedList<FetchValue> fetchValueOperations = new LinkedList<FetchValue>();
        for (Location location : this.locations) {
            FetchValue.Builder builder = new FetchValue.Builder(location);
            for (FetchValue.Option<?> option : this.options.keySet()) {
                builder.withOption(option, this.options.get(option));
            }
            fetchValueOperations.add(builder.build());
        }
        return fetchValueOperations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.locations.hashCode();
        result = 31 * result + this.options.hashCode();
        result = 31 * result + this.maxInFlight;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FetchValue)) {
            return false;
        }
        MultiFetch other = (MultiFetch)obj;
        if (!(this.locations == other.locations || this.locations != null && this.locations.equals(other.locations))) {
            return false;
        }
        if (!(this.options == other.options || this.options != null && this.options.equals(other.options))) {
            return false;
        }
        return this.maxInFlight == other.maxInFlight;
    }

    public String toString() {
        return String.format("{locations: %s, options: %s, maxInFlight: %s}", this.locations, this.options, this.maxInFlight);
    }

    private class MultiFetchFuture
    extends ListenableFuture<Response, List<Location>> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final List<Location> locations;
        private final List<RiakFuture<FetchValue.Response, Location>> futures;
        private volatile Throwable exception;

        private MultiFetchFuture(List<Location> locations) {
            this.locations = locations;
            this.futures = Collections.synchronizedList(new LinkedList());
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public Response get() throws InterruptedException {
            this.latch.await();
            return new Response(this.futures);
        }

        @Override
        public Response get(long timeout, TimeUnit unit) throws InterruptedException {
            this.latch.await(timeout, unit);
            if (this.isDone()) {
                return new Response(this.futures);
            }
            return null;
        }

        @Override
        public Response getNow() {
            if (this.isDone()) {
                return new Response(this.futures);
            }
            return null;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() != 1L;
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }

        @Override
        public void await(long timeout, TimeUnit unit) throws InterruptedException {
            this.latch.await(timeout, unit);
        }

        @Override
        public boolean isSuccess() {
            return this.isDone() && this.exception == null;
        }

        @Override
        public List<Location> getQueryInfo() {
            return this.locations;
        }

        @Override
        public Throwable cause() {
            return this.exception;
        }

        private void addFetchFuture(RiakFuture<FetchValue.Response, Location> future) {
            this.futures.add(future);
        }

        private void setCompleted() {
            this.latch.countDown();
            this.notifyListeners();
        }

        private void setFailed(Throwable t) {
            this.exception = t;
            this.latch.countDown();
            this.notifyListeners();
        }
    }

    private class Submitter
    implements Runnable,
    RiakFutureListener<FetchValue.Response, Location> {
        private final List<FetchValue> operations;
        private final Semaphore inFlight;
        private final AtomicInteger received = new AtomicInteger();
        private final RiakCluster cluster;
        private final MultiFetchFuture multiFuture;

        public Submitter(List<FetchValue> operations, int maxInFlight, RiakCluster cluster, MultiFetchFuture multiFuture) {
            this.operations = operations;
            this.cluster = cluster;
            this.multiFuture = multiFuture;
            this.inFlight = new Semaphore(maxInFlight);
        }

        @Override
        public void run() {
            for (FetchValue fv : this.operations) {
                try {
                    this.inFlight.acquire();
                }
                catch (InterruptedException ex) {
                    this.multiFuture.setFailed(ex);
                    break;
                }
                RiakFuture<FetchValue.Response, Location> future = fv.executeAsync(this.cluster);
                future.addListener(this);
            }
        }

        @Override
        public void handle(RiakFuture<FetchValue.Response, Location> f) {
            this.multiFuture.addFetchFuture(f);
            this.inFlight.release();
            int completed = this.received.incrementAndGet();
            if (completed == this.operations.size()) {
                this.multiFuture.setCompleted();
            }
        }
    }

    public static final class Response
    implements Iterable<RiakFuture<FetchValue.Response, Location>> {
        private final List<RiakFuture<FetchValue.Response, Location>> responses;

        Response(List<RiakFuture<FetchValue.Response, Location>> responses) {
            this.responses = responses;
        }

        @Override
        public Iterator<RiakFuture<FetchValue.Response, Location>> iterator() {
            return Collections.unmodifiableList(this.responses).iterator();
        }

        public List<RiakFuture<FetchValue.Response, Location>> getResponses() {
            return this.responses;
        }
    }

    public static class Builder {
        private ArrayList<Location> keys = new ArrayList();
        private Map<FetchValue.Option<?>, Object> options = new HashMap();
        private int maxInFlight = 10;

        public Builder addLocation(Location location) {
            this.keys.add(location);
            return this;
        }

        public Builder addLocations(Location ... location) {
            this.keys.addAll(Arrays.asList(location));
            return this;
        }

        public Builder addLocations(Iterable<Location> location) {
            for (Location loc : location) {
                this.keys.add(loc);
            }
            return this;
        }

        public Builder withMaxInFlight(int maxInFlight) {
            this.maxInFlight = maxInFlight;
            return this;
        }

        public <U> Builder withOption(FetchValue.Option<U> option, U value) {
            this.options.put(option, value);
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.withOption(FetchValue.Option.TIMEOUT, timeout);
            return this;
        }

        public MultiFetch build() {
            return new MultiFetch(this);
        }
    }
}

