/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.convert.reflection;

import com.basho.riak.client.api.cap.BasicVClock;
import com.basho.riak.client.api.cap.VClock;
import com.basho.riak.client.api.convert.reflection.ClassUtil;
import com.basho.riak.client.api.convert.reflection.RiakIndexField;
import com.basho.riak.client.api.convert.reflection.RiakIndexMethod;
import com.basho.riak.client.api.convert.reflection.UsermetaField;
import com.basho.riak.client.api.convert.reflection.UsermetaMethod;
import com.basho.riak.client.core.query.UserMetadata.RiakUserMetadata;
import com.basho.riak.client.core.query.indexes.BigIntIndex;
import com.basho.riak.client.core.query.indexes.IndexType;
import com.basho.riak.client.core.query.indexes.LongIntIndex;
import com.basho.riak.client.core.query.indexes.RawIndex;
import com.basho.riak.client.core.query.indexes.RiakIndexes;
import com.basho.riak.client.core.query.indexes.StringBinIndex;
import com.basho.riak.client.core.query.links.RiakLink;
import com.basho.riak.client.core.query.links.RiakLinks;
import com.basho.riak.client.core.util.BinaryValue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnnotationInfo {
    private final Field riakKeyField;
    private final Method riakKeySetter;
    private final Method riakKeyGetter;
    private final List<UsermetaField> usermetaFields;
    private final List<UsermetaMethod> usermetaMethods;
    private final List<RiakIndexField> indexFields;
    private final List<RiakIndexMethod> indexMethods;
    private final Field riakLinksField;
    private final Method riakLinksGetter;
    private final Method riakLinksSetter;
    private final Field riakVClockField;
    private final Method riakVClockSetter;
    private final Method riakVClockGetter;
    private final Field riakTombstoneField;
    private final Method riakTombstoneSetter;
    private final Method riakTombstoneGetter;
    private final Field riakContentTypeField;
    private final Method riakContentTypeGetter;
    private final Method riakContentTypeSetter;
    private final Field riakLastModifiedField;
    private final Method riakLastModifiedSetter;
    private final Field riakVTagField;
    private final Method riakVTagSetter;
    private final Field riakBucketNameField;
    private final Method riakBucketNameSetter;
    private final Method riakBucketNameGetter;
    private final Field riakBucketTypeField;
    private final Method riakBucketTypeSetter;
    private final Method riakBucketTypeGetter;

    private AnnotationInfo(Builder builder) {
        this.riakKeyField = builder.riakKeyField;
        this.riakKeyGetter = builder.riakKeyGetter;
        this.riakKeySetter = builder.riakKeySetter;
        this.riakLinksField = builder.riakLinksField;
        this.riakLinksGetter = builder.riakLinksGetter;
        this.riakLinksSetter = builder.riakLinksSetter;
        this.riakVClockField = builder.riakVClockField;
        this.riakVClockGetter = builder.riakVClockGetter;
        this.riakVClockSetter = builder.riakVClockSetter;
        this.riakTombstoneField = builder.riakTombstoneField;
        this.riakTombstoneGetter = builder.riakTombstoneGetter;
        this.riakTombstoneSetter = builder.riakTombstoneSetter;
        this.usermetaFields = builder.usermetaFields;
        this.usermetaMethods = builder.usermetaMethods;
        this.indexFields = builder.indexFields;
        this.indexMethods = builder.indexMethods;
        this.riakContentTypeField = builder.riakContentTypeField;
        this.riakContentTypeGetter = builder.riakContentTypeGetter;
        this.riakContentTypeSetter = builder.riakContentTypeSetter;
        this.riakLastModifiedField = builder.riakLastModifiedField;
        this.riakLastModifiedSetter = builder.riakLastModified;
        this.riakVTagField = builder.riakVTagField;
        this.riakVTagSetter = builder.riakVTagSetter;
        this.riakBucketNameField = builder.riakBucketNameField;
        this.riakBucketNameGetter = builder.riakBucketNameGetter;
        this.riakBucketNameSetter = builder.riakBucketNameSetter;
        this.riakBucketTypeField = builder.riakBucketTypeField;
        this.riakBucketTypeGetter = builder.riakBucketTypeGetter;
        this.riakBucketTypeSetter = builder.riakBucketTypeSetter;
    }

    public <T> BinaryValue getRiakKey(T obj) {
        BinaryValue key = null;
        if (this.riakKeyGetter != null) {
            if (this.riakKeyGetter.getReturnType().isArray()) {
                Object o = ClassUtil.getMethodValue(this.riakKeyGetter, obj);
                if (o != null) {
                    key = BinaryValue.create((byte[])o);
                }
            } else {
                Object o = ClassUtil.getMethodValue(this.riakKeyGetter, obj);
                if (o != null) {
                    key = BinaryValue.create((String)o);
                }
            }
        } else if (this.riakKeyField != null) {
            if (this.riakKeyField.getType().equals(String.class)) {
                Object o = ClassUtil.getFieldValue(this.riakKeyField, obj);
                if (o != null) {
                    key = BinaryValue.create((String)o);
                }
            } else {
                Object o = ClassUtil.getFieldValue(this.riakKeyField, obj);
                if (o != null) {
                    key = BinaryValue.create((byte[])o);
                }
            }
        }
        return key;
    }

    public <T> void setRiakKey(T obj, BinaryValue key) {
        if (this.riakKeySetter != null) {
            if (this.riakKeySetter.getParameterTypes()[0].isArray()) {
                ClassUtil.setMethodValue(this.riakKeySetter, obj, key.unsafeGetValue());
            } else {
                ClassUtil.setMethodValue(this.riakKeySetter, obj, key.toString());
            }
        } else if (this.riakKeyField != null) {
            if (this.riakKeyField.getType().equals(String.class)) {
                ClassUtil.setFieldValue(this.riakKeyField, obj, key.toString());
            } else {
                ClassUtil.setFieldValue(this.riakKeyField, obj, key.unsafeGetValue());
            }
        }
    }

    public <T> BinaryValue getRiakBucketName(T obj) {
        BinaryValue bucketName = null;
        if (this.riakBucketNameGetter != null) {
            if (this.riakBucketNameGetter.getReturnType().isArray()) {
                Object o = ClassUtil.getMethodValue(this.riakBucketNameGetter, obj);
                if (o != null) {
                    bucketName = BinaryValue.create((byte[])o);
                }
            } else {
                Object o = ClassUtil.getMethodValue(this.riakBucketNameGetter, obj);
                if (o != null) {
                    bucketName = BinaryValue.create((String)o);
                }
            }
        } else if (this.riakBucketNameField != null) {
            if (this.riakBucketNameField.getType().equals(String.class)) {
                Object o = ClassUtil.getFieldValue(this.riakBucketNameField, obj);
                if (o != null) {
                    bucketName = BinaryValue.create((String)o);
                }
            } else {
                Object o = ClassUtil.getFieldValue(this.riakBucketNameField, obj);
                if (o != null) {
                    bucketName = BinaryValue.create((byte[])o);
                }
            }
        }
        return bucketName;
    }

    public <T> void setRiakBucketName(T obj, BinaryValue bucketName) {
        if (this.riakBucketNameSetter != null) {
            if (this.riakBucketNameSetter.getParameterTypes()[0].isArray()) {
                ClassUtil.setMethodValue(this.riakBucketNameSetter, obj, bucketName.unsafeGetValue());
            } else {
                ClassUtil.setMethodValue(this.riakBucketNameSetter, obj, bucketName.toString());
            }
        } else if (this.riakBucketNameField != null) {
            if (this.riakBucketNameField.getType().equals(String.class)) {
                ClassUtil.setFieldValue(this.riakBucketNameField, obj, bucketName.toString());
            } else {
                ClassUtil.setFieldValue(this.riakBucketNameField, obj, bucketName.unsafeGetValue());
            }
        }
    }

    public <T> BinaryValue getRiakBucketType(T obj) {
        BinaryValue bucketType = null;
        if (this.riakBucketTypeGetter != null) {
            if (this.riakBucketTypeGetter.getReturnType().isArray()) {
                Object o = ClassUtil.getMethodValue(this.riakBucketTypeGetter, obj);
                if (o != null) {
                    bucketType = BinaryValue.create((byte[])o);
                }
            } else {
                Object o = ClassUtil.getMethodValue(this.riakBucketTypeGetter, obj);
                if (o != null) {
                    bucketType = BinaryValue.create((String)o);
                }
            }
        } else if (this.riakBucketTypeField != null) {
            if (this.riakBucketTypeField.getType().equals(String.class)) {
                Object o = ClassUtil.getFieldValue(this.riakBucketTypeField, obj);
                if (o != null) {
                    bucketType = BinaryValue.create((String)o);
                }
            } else {
                Object o = ClassUtil.getFieldValue(this.riakBucketTypeField, obj);
                if (o != null) {
                    bucketType = BinaryValue.create((byte[])o);
                }
            }
        }
        return bucketType;
    }

    public <T> void setRiakBucketType(T obj, BinaryValue bucketType) {
        if (this.riakBucketTypeSetter != null) {
            if (this.riakBucketTypeSetter.getParameterTypes()[0].isArray()) {
                ClassUtil.setMethodValue(this.riakBucketTypeSetter, obj, bucketType.unsafeGetValue());
            } else {
                ClassUtil.setMethodValue(this.riakBucketTypeSetter, obj, bucketType.toString());
            }
        } else if (this.riakBucketTypeField != null) {
            if (this.riakBucketTypeField.getType().equals(String.class)) {
                ClassUtil.setFieldValue(this.riakBucketTypeField, obj, bucketType.toString());
            } else {
                ClassUtil.setFieldValue(this.riakBucketTypeField, obj, bucketType.unsafeGetValue());
            }
        }
    }

    public boolean hasRiakVClock() {
        return this.riakVClockField != null || this.riakVClockSetter != null;
    }

    public <T> VClock getRiakVClock(T obj) {
        VClock vclock = null;
        if (this.riakVClockGetter != null) {
            vclock = this.riakVClockGetter.getReturnType().isArray() ? new BasicVClock((byte[])ClassUtil.getMethodValue(this.riakVClockGetter, obj)) : (VClock)ClassUtil.getMethodValue(this.riakVClockGetter, obj);
        } else if (this.riakVClockField != null) {
            vclock = this.riakVClockField.getType().isAssignableFrom(VClock.class) ? (VClock)ClassUtil.getFieldValue(this.riakVClockField, obj) : new BasicVClock((byte[])ClassUtil.getFieldValue(this.riakVClockField, obj));
        }
        return vclock;
    }

    public <T> void setRiakVClock(T obj, VClock vclock) {
        if (this.riakVClockSetter != null) {
            Class<?> pType = this.riakVClockSetter.getParameterTypes()[0];
            if (pType.isArray()) {
                ClassUtil.setMethodValue(this.riakVClockSetter, obj, vclock.getBytes());
            } else {
                ClassUtil.setMethodValue(this.riakVClockSetter, obj, vclock);
            }
        } else if (this.riakVClockField != null) {
            if (this.riakVClockField.getType().isAssignableFrom(VClock.class)) {
                ClassUtil.setFieldValue(this.riakVClockField, obj, vclock);
            } else {
                ClassUtil.setFieldValue(this.riakVClockField, obj, vclock.getBytes());
            }
        }
    }

    public <T> Boolean getRiakTombstone(T obj) {
        Boolean tombstone = null;
        if (this.riakTombstoneGetter != null) {
            tombstone = (Boolean)ClassUtil.getMethodValue(this.riakTombstoneGetter, obj);
        } else if (this.riakTombstoneField != null) {
            tombstone = (Boolean)ClassUtil.getFieldValue(this.riakTombstoneField, obj);
        }
        return tombstone;
    }

    public <T> void setRiakTombstone(T obj, Boolean isDeleted) {
        if (this.riakTombstoneSetter != null) {
            ClassUtil.setMethodValue(this.riakTombstoneSetter, obj, isDeleted);
        } else if (this.riakTombstoneField != null) {
            ClassUtil.setFieldValue(this.riakTombstoneField, obj, isDeleted);
        }
    }

    public <T> String getRiakContentType(T obj) {
        String contentType = null;
        if (this.riakContentTypeGetter != null) {
            contentType = (String)ClassUtil.getMethodValue(this.riakContentTypeGetter, obj);
        } else if (this.riakContentTypeField != null) {
            contentType = (String)ClassUtil.getFieldValue(this.riakContentTypeField, obj);
        }
        return contentType;
    }

    public <T> void setRiakContentType(T obj, String contentType) {
        if (this.riakContentTypeSetter != null) {
            ClassUtil.setMethodValue(this.riakContentTypeSetter, obj, contentType);
        } else if (this.riakContentTypeField != null) {
            ClassUtil.setFieldValue(this.riakContentTypeField, obj, contentType);
        }
    }

    public <T> void setRiakLastModified(T obj, Long lastModified) {
        if (this.riakLastModifiedSetter != null) {
            ClassUtil.setMethodValue(this.riakLastModifiedSetter, obj, lastModified);
        } else if (this.riakLastModifiedField != null) {
            ClassUtil.setFieldValue(this.riakLastModifiedField, obj, lastModified);
        }
    }

    public <T> void setRiakVTag(T obj, String vtag) {
        if (this.riakVTagSetter != null) {
            ClassUtil.setMethodValue(this.riakVTagSetter, obj, vtag);
        } else if (this.riakVTagField != null) {
            ClassUtil.setFieldValue(this.riakVTagField, obj, vtag);
        }
    }

    public <T> RiakUserMetadata getUsermetaData(RiakUserMetadata container, T obj) {
        String key;
        String val;
        Object o;
        Map map;
        for (UsermetaField uf : this.usermetaFields) {
            switch (uf.getFieldType()) {
                case MAP: {
                    map = (Map)ClassUtil.getFieldValue(uf.getField(), obj);
                    if (map == null) break;
                    container.put(map);
                    break;
                }
                case STRING: {
                    o = ClassUtil.getFieldValue(uf.getField(), obj);
                    val = o == null ? null : o.toString();
                    key = uf.getUsermetaDataKey();
                    if (o == null) break;
                    container.put(key, val);
                    break;
                }
            }
        }
        for (UsermetaMethod um : this.usermetaMethods) {
            switch (um.getMethodType()) {
                case MAP_GETTER: {
                    map = (Map)ClassUtil.getMethodValue(um.getMethod(), obj);
                    if (map == null) break;
                    container.put(map);
                    break;
                }
                case STRING_GETTER: {
                    o = ClassUtil.getMethodValue(um.getMethod(), obj);
                    val = o == null ? null : o.toString();
                    key = um.getUsermetaDataKey();
                    if (o == null) break;
                    container.put(key, val);
                    break;
                }
            }
        }
        return container;
    }

    public <T> void setUsermetaData(RiakUserMetadata userMetadata, T obj) {
        Field mapField = null;
        for (UsermetaField uf : this.usermetaFields) {
            switch (uf.getFieldType()) {
                case STRING: {
                    if (!userMetadata.containsKey(uf.getUsermetaDataKey())) break;
                    ClassUtil.setFieldValue(uf.getField(), obj, userMetadata.get(uf.getUsermetaDataKey()));
                    userMetadata.remove(uf.getUsermetaDataKey());
                    break;
                }
                case MAP: {
                    mapField = uf.getField();
                    break;
                }
            }
        }
        Method mapSetter = null;
        for (UsermetaMethod um : this.usermetaMethods) {
            switch (um.getMethodType()) {
                case STRING_SETTER: {
                    if (!userMetadata.containsKey(um.getUsermetaDataKey())) break;
                    ClassUtil.setMethodValue(um.getMethod(), obj, userMetadata.get(um.getUsermetaDataKey()));
                    userMetadata.remove(um.getUsermetaDataKey());
                    break;
                }
                case MAP_SETTER: {
                    mapSetter = um.getMethod();
                    break;
                }
            }
        }
        if (mapSetter != null || mapField != null) {
            HashMap<String, String> mapCopy = new HashMap<String, String>(userMetadata.size());
            for (Map.Entry<BinaryValue, BinaryValue> entry : userMetadata.getUserMetadata()) {
                mapCopy.put(entry.getKey().toString(), entry.getValue().toString());
            }
            if (mapSetter != null) {
                ClassUtil.setMethodValue(mapSetter, obj, mapCopy);
            }
            if (mapField != null) {
                ClassUtil.setFieldValue(mapField, obj, mapCopy);
            }
        }
    }

    public <T> RiakIndexes getIndexes(RiakIndexes container, T obj) {
        RawIndex rawIndex;
        IndexType iType;
        BigIntIndex bigIntIndex;
        StringBinIndex stringBinIndex;
        Object val;
        block12: for (RiakIndexField f : this.indexFields) {
            val = ClassUtil.getFieldValue(f.getField(), obj);
            switch (f.getFieldType()) {
                case SET_LONG: 
                case LONG: {
                    LongIntIndex longIndex = (LongIntIndex)container.getIndex(LongIntIndex.named(f.getIndexName()));
                    if (val == null) break;
                    if (f.getFieldType() == RiakIndexField.FieldType.SET_LONG) {
                        longIndex.add((Set)val);
                        break;
                    }
                    longIndex.add((Long)val);
                    break;
                }
                case SET_STRING: 
                case STRING: {
                    stringBinIndex = (StringBinIndex)container.getIndex(StringBinIndex.named(f.getIndexName()));
                    if (val == null) break;
                    if (f.getFieldType() == RiakIndexField.FieldType.SET_STRING) {
                        stringBinIndex.add((Set)val);
                        break;
                    }
                    stringBinIndex.add((String)val);
                    break;
                }
                case SET_BIG_INT: 
                case BIG_INT: {
                    bigIntIndex = (BigIntIndex)container.getIndex(BigIntIndex.named(f.getIndexName()));
                    if (val == null) break;
                    if (f.getFieldType() == RiakIndexField.FieldType.SET_BIG_INT) {
                        bigIntIndex.add((Set)val);
                        break;
                    }
                    bigIntIndex.add((BigInteger)val);
                    break;
                }
                case SET_RAW: 
                case RAW: {
                    iType = IndexType.typeFromFullname(f.getIndexName());
                    rawIndex = (RawIndex)container.getIndex(RawIndex.named(f.getIndexName(), iType));
                    if (val == null) break;
                    if (f.getFieldType() == RiakIndexField.FieldType.SET_RAW) {
                        for (byte[] bytes : (Set)val) {
                            rawIndex.add(BinaryValue.create(bytes));
                        }
                        continue block12;
                    }
                    rawIndex.add(BinaryValue.create((byte[])val));
                }
            }
        }
        block14: for (RiakIndexMethod m : this.indexMethods) {
            switch (m.getMethodType()) {
                case SET_LONG_GETTER: 
                case LONG_GETTER: {
                    val = ClassUtil.getMethodValue(m.getMethod(), obj);
                    LongIntIndex index = (LongIntIndex)container.getIndex(LongIntIndex.named(m.getIndexName()));
                    if (val == null) break;
                    if (m.getMethodType() == RiakIndexMethod.MethodType.SET_LONG_GETTER) {
                        index.add((Set)val);
                        break;
                    }
                    index.add((Long)val);
                    break;
                }
                case SET_STRING_GETTER: 
                case STRING_GETTER: {
                    val = ClassUtil.getMethodValue(m.getMethod(), obj);
                    stringBinIndex = (StringBinIndex)container.getIndex(StringBinIndex.named(m.getIndexName()));
                    if (val == null) break;
                    if (m.getMethodType() == RiakIndexMethod.MethodType.SET_STRING_GETTER) {
                        stringBinIndex.add((Set)val);
                        break;
                    }
                    stringBinIndex.add((String)val);
                    break;
                }
                case SET_BIG_INT_GETTER: 
                case BIG_INT_GETTER: {
                    val = ClassUtil.getMethodValue(m.getMethod(), obj);
                    bigIntIndex = (BigIntIndex)container.getIndex(BigIntIndex.named(m.getIndexName()));
                    if (val == null) break;
                    if (m.getMethodType() == RiakIndexMethod.MethodType.SET_BIG_INT_GETTER) {
                        bigIntIndex.add((Set)val);
                        break;
                    }
                    bigIntIndex.add((BigInteger)val);
                    break;
                }
                case SET_RAW_GETTER: 
                case RAW_GETTER: {
                    val = ClassUtil.getMethodValue(m.getMethod(), obj);
                    iType = IndexType.typeFromFullname(m.getIndexName());
                    rawIndex = (RawIndex)container.getIndex(RawIndex.named(m.getIndexName(), iType));
                    if (val == null) break;
                    if (m.getMethodType() == RiakIndexMethod.MethodType.SET_RAW_GETTER) {
                        for (byte[] bytes : (Set)val) {
                            rawIndex.add(BinaryValue.create(bytes));
                        }
                        continue block14;
                    }
                    rawIndex.add(BinaryValue.create((byte[])val));
                }
            }
        }
        return container;
    }

    public <T> void setIndexes(RiakIndexes indexes, T obj) {
        HashSet byteSet;
        RawIndex rawIndex;
        IndexType iType;
        BigIntIndex bigIntIndex;
        StringBinIndex stringIndex;
        LongIntIndex longIndex;
        Set val;
        for (RiakIndexField f : this.indexFields) {
            val = null;
            switch (f.getFieldType()) {
                case SET_LONG: 
                case LONG: {
                    longIndex = (LongIntIndex)indexes.getIndex(LongIntIndex.named(f.getIndexName()));
                    val = longIndex.values();
                    break;
                }
                case SET_STRING: 
                case STRING: {
                    stringIndex = (StringBinIndex)indexes.getIndex(StringBinIndex.named(f.getIndexName()));
                    val = stringIndex.values();
                    break;
                }
                case SET_BIG_INT: 
                case BIG_INT: {
                    bigIntIndex = (BigIntIndex)indexes.getIndex(BigIntIndex.named(f.getIndexName()));
                    val = bigIntIndex.values();
                    break;
                }
                case SET_RAW: 
                case RAW: {
                    iType = IndexType.typeFromFullname(f.getIndexName());
                    rawIndex = (RawIndex)indexes.getIndex(RawIndex.named(f.getIndexName(), iType));
                    byteSet = new HashSet();
                    for (BinaryValue bv : rawIndex.values()) {
                        byteSet.add(bv.unsafeGetValue());
                    }
                    val = byteSet;
                    break;
                }
            }
            if (val == null) continue;
            if (f.getFieldType() == RiakIndexField.FieldType.LONG || f.getFieldType() == RiakIndexField.FieldType.STRING || f.getFieldType() == RiakIndexField.FieldType.BIG_INT || f.getFieldType() == RiakIndexField.FieldType.RAW) {
                if (val.isEmpty()) continue;
                ClassUtil.setFieldValue(f.getField(), obj, val.iterator().next());
                continue;
            }
            ClassUtil.setFieldValue(f.getField(), obj, val);
        }
        for (RiakIndexMethod m : this.indexMethods) {
            val = null;
            switch (m.getMethodType()) {
                case SET_LONG_SETTER: 
                case LONG_SETTER: {
                    longIndex = (LongIntIndex)indexes.getIndex(LongIntIndex.named(m.getIndexName()));
                    val = longIndex.values();
                    break;
                }
                case SET_STRING_SETTER: 
                case STRING_SETTER: {
                    stringIndex = (StringBinIndex)indexes.getIndex(StringBinIndex.named(m.getIndexName()));
                    val = stringIndex.values();
                    break;
                }
                case SET_BIG_INT_SETTER: 
                case BIG_INT_SETTER: {
                    bigIntIndex = (BigIntIndex)indexes.getIndex(BigIntIndex.named(m.getIndexName()));
                    val = bigIntIndex.values();
                    break;
                }
                case SET_RAW_SETTER: 
                case RAW_SETTER: {
                    iType = IndexType.typeFromFullname(m.getIndexName());
                    rawIndex = (RawIndex)indexes.getIndex(RawIndex.named(m.getIndexName(), iType));
                    byteSet = new HashSet();
                    for (BinaryValue bv : rawIndex.values()) {
                        byteSet.add(bv.unsafeGetValue());
                    }
                    val = byteSet;
                    break;
                }
            }
            if (val == null) continue;
            if (m.getMethodType() == RiakIndexMethod.MethodType.LONG_SETTER || m.getMethodType() == RiakIndexMethod.MethodType.STRING_SETTER || m.getMethodType() == RiakIndexMethod.MethodType.BIG_INT_SETTER || m.getMethodType() == RiakIndexMethod.MethodType.RAW_SETTER) {
                if (val.isEmpty()) continue;
                ClassUtil.setMethodValue(m.getMethod(), obj, val.iterator().next());
                continue;
            }
            ClassUtil.setMethodValue(m.getMethod(), obj, val);
        }
    }

    public <T> RiakLinks getLinks(RiakLinks container, T obj) {
        Object o = null;
        if (this.riakLinksGetter != null) {
            o = ClassUtil.getMethodValue(this.riakLinksGetter, obj);
        } else if (this.riakLinksField != null) {
            o = ClassUtil.getFieldValue(this.riakLinksField, obj);
        }
        if (o != null) {
            container.addLinks((Collection)o);
        }
        return container;
    }

    public <T> void setLinks(RiakLinks links, T obj) {
        if (this.riakLinksSetter != null) {
            ClassUtil.setMethodValue(this.riakLinksSetter, obj, links.getLinks());
        } else if (this.riakLinksField != null) {
            ClassUtil.setFieldValue(this.riakLinksField, obj, links.getLinks());
        }
    }

    public static class Builder {
        private Field riakKeyField;
        private Method riakKeySetter;
        private Method riakKeyGetter;
        private Field riakLinksField;
        private Method riakLinksGetter;
        private Method riakLinksSetter;
        private Field riakVClockField;
        private Method riakVClockSetter;
        private Method riakVClockGetter;
        private Field riakTombstoneField;
        private Method riakTombstoneSetter;
        private Method riakTombstoneGetter;
        private Field riakContentTypeField;
        private Method riakContentTypeGetter;
        private Method riakContentTypeSetter;
        private Field riakLastModifiedField;
        private Method riakLastModified;
        private Field riakVTagField;
        private Method riakVTagSetter;
        private Field riakBucketNameField;
        private Method riakBucketNameSetter;
        private Method riakBucketNameGetter;
        private Field riakBucketTypeField;
        private Method riakBucketTypeSetter;
        private Method riakBucketTypeGetter;
        private final List<UsermetaField> usermetaFields = new LinkedList<UsermetaField>();
        private final List<UsermetaMethod> usermetaMethods = new LinkedList<UsermetaMethod>();
        private final List<RiakIndexField> indexFields = new LinkedList<RiakIndexField>();
        private final List<RiakIndexMethod> indexMethods = new LinkedList<RiakIndexMethod>();

        public Builder withRiakKeyField(Field f) {
            this.validateStringOrByteField(f, "@RiakKey");
            this.riakKeyField = ClassUtil.checkAndFixAccess(f);
            return this;
        }

        public Builder withRiakKeyGetter(Method m) {
            this.validateStringOrByteMethod(m, "@RiakKey");
            this.riakKeyGetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakKeySetter(Method m) {
            this.validateStringOrByteMethod(m, "@RiakKey");
            this.riakKeySetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakLinksField(Field f) {
            this.validateRiakLinksField(f);
            this.riakLinksField = ClassUtil.checkAndFixAccess(f);
            return this;
        }

        public Builder withRiakLinksGetter(Method m) {
            this.validateRiakLinksMethod(m);
            this.riakLinksGetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakLinksSetter(Method m) {
            this.validateRiakLinksMethod(m);
            this.riakLinksSetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder addRiakUsermetaField(Field f) {
            this.usermetaFields.add(new UsermetaField(ClassUtil.checkAndFixAccess(f)));
            return this;
        }

        public Builder addRiakUsermetaMethod(Method m) {
            this.usermetaMethods.add(new UsermetaMethod(ClassUtil.checkAndFixAccess(m)));
            return this;
        }

        public Builder addRiakIndexMethod(Method m) {
            this.indexMethods.add(new RiakIndexMethod(ClassUtil.checkAndFixAccess(m)));
            return this;
        }

        public Builder addRiakIndexField(Field f) {
            this.indexFields.add(new RiakIndexField(ClassUtil.checkAndFixAccess(f)));
            return this;
        }

        public Builder withRiakVClockField(Field f) {
            this.validateVClockField(f);
            this.riakVClockField = ClassUtil.checkAndFixAccess(f);
            return this;
        }

        public Builder withRiakVClockSetter(Method m) {
            this.validateVClockMethod(m);
            this.riakVClockSetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakVClockGetter(Method m) {
            this.validateVClockMethod(m);
            this.riakVClockGetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakTombstoneField(Field f) {
            this.validateTombstoneField(f);
            this.riakTombstoneField = ClassUtil.checkAndFixAccess(f);
            return this;
        }

        public Builder withRiakTombstoneSetter(Method m) {
            this.validateTombstoneMethod(m);
            this.riakTombstoneSetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakTombstoneGetter(Method m) {
            this.validateTombstoneMethod(m);
            this.riakTombstoneGetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakContentTypeField(Field f) {
            this.validateContentTypeField(f);
            this.riakContentTypeField = ClassUtil.checkAndFixAccess(f);
            return this;
        }

        public Builder withRiakContentTypeSetter(Method m) {
            this.validateContentTypeMethod(m);
            this.riakContentTypeSetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakContentTypeGetter(Method m) {
            this.validateContentTypeMethod(m);
            this.riakContentTypeGetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakLastModifiedField(Field f) {
            this.validateLastModifiedField(f);
            this.riakLastModifiedField = ClassUtil.checkAndFixAccess(f);
            return this;
        }

        public Builder withRiakLastModifiedSetter(Method m) {
            this.validateLastModifiedMethod(m);
            this.riakLastModified = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakVTagField(Field f) {
            this.validateVTagField(f);
            this.riakVTagField = ClassUtil.checkAndFixAccess(f);
            return this;
        }

        public Builder withRiakVTagSetter(Method m) {
            this.validateVTagMethod(m);
            this.riakVTagSetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakBucketNameField(Field f) {
            this.validateStringOrByteField(f, "@RiakBucketName");
            this.riakBucketNameField = ClassUtil.checkAndFixAccess(f);
            return this;
        }

        public Builder withRiakBucketNameSetter(Method m) {
            this.validateStringOrByteMethod(m, "@RiakBucketName");
            this.riakBucketNameSetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakBucketNameGetter(Method m) {
            this.validateStringOrByteMethod(m, "@RiakBucketName");
            this.riakBucketNameGetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakBucketTypeField(Field f) {
            this.validateStringOrByteField(f, "@RiakBucketType");
            this.riakBucketTypeField = ClassUtil.checkAndFixAccess(f);
            return this;
        }

        public Builder withRiakBucketTypeSetter(Method m) {
            this.validateStringOrByteMethod(m, "@RiakBucketType");
            this.riakBucketTypeSetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public Builder withRiakBucketTypeGetter(Method m) {
            this.validateStringOrByteMethod(m, "@RiakBucketType");
            this.riakBucketTypeGetter = ClassUtil.checkAndFixAccess(m);
            return this;
        }

        public AnnotationInfo build() {
            return new AnnotationInfo(this);
        }

        private void validateRiakLinksField(Field riakLinksField) {
            Type[] genericParams;
            ParameterizedType type;
            Type t;
            if (Collection.class.isAssignableFrom(riakLinksField.getType()) ? (t = riakLinksField.getGenericType()) instanceof ParameterizedType && (type = (ParameterizedType)t).getRawType().equals(Collection.class) && (genericParams = type.getActualTypeArguments()).length == 1 && genericParams[0].equals(RiakLink.class) : riakLinksField.getType().equals(RiakLinks.class)) {
                return;
            }
            throw new IllegalArgumentException("@RiakLinks field must be Collection<RiakLink>");
        }

        private void validateRiakLinksMethod(Method m) {
            if (m.getParameterTypes().length == 1) {
                Class genericType;
                ParameterizedType pType;
                Type[] genericParameterTypes = m.getGenericParameterTypes();
                Type t = genericParameterTypes[0];
                if (t instanceof ParameterizedType && (pType = (ParameterizedType)t).getRawType().equals(Collection.class) && RiakLink.class.equals((Object)(genericType = (Class)pType.getActualTypeArguments()[0]))) {
                    return;
                }
                throw new IllegalArgumentException("@RiakLinks setter must take Collection<RiakLink>");
            }
            if (m.getParameterTypes().length == 0) {
                Class genericType;
                ParameterizedType pType;
                Type t = m.getGenericReturnType();
                if (t instanceof ParameterizedType && (pType = (ParameterizedType)t).getRawType().equals(Collection.class) && RiakLink.class.equals((Object)(genericType = (Class)pType.getActualTypeArguments()[0]))) {
                    return;
                }
                throw new IllegalArgumentException("@RiakLinks getter must return Collection<RiakLink>");
            }
        }

        private void validateVClockField(Field f) {
            if (!(f.getType().isArray() && f.getType().getComponentType().equals(Byte.TYPE) || f.getType().isAssignableFrom(VClock.class))) {
                throw new IllegalArgumentException("@RiakVClock field must be a VClock or byte[]");
            }
        }

        private void validateVClockMethod(Method m) {
            Class<VClock> rType;
            if (m.getParameterTypes().length == 1) {
                Class<VClock> pType = m.getParameterTypes()[0];
                if (!(pType.isArray() && pType.getComponentType().equals(Byte.TYPE) || pType.isAssignableFrom(VClock.class))) {
                    throw new IllegalArgumentException("@RiakVClock setter must take VClock or byte[]");
                }
            } else if (!(m.getParameterTypes().length != 0 || (rType = m.getReturnType()).isArray() && rType.getComponentType().equals(Byte.TYPE) || rType.isAssignableFrom(VClock.class))) {
                throw new IllegalArgumentException("@RiakVClock getter must return VClock or byte[]");
            }
        }

        private void validateTombstoneField(Field f) {
            if (!f.getType().equals(Boolean.class) && !f.getType().equals(Boolean.TYPE)) {
                throw new IllegalArgumentException("@RiakTombstone field must be Boolean or boolean");
            }
        }

        private void validateTombstoneMethod(Method m) {
            Class<?> rType;
            if (m.getParameterTypes().length == 1) {
                Class<?> pType = m.getParameterTypes()[0];
                if (!pType.equals(Boolean.class) && !pType.equals(Boolean.TYPE)) {
                    throw new IllegalArgumentException("@RiakTombstone setter must take boolean or Boolean");
                }
            } else if (m.getParameterTypes().length == 0 && !(rType = m.getReturnType()).equals(Boolean.class) && !rType.equals(Boolean.TYPE)) {
                throw new IllegalArgumentException("@RiakTombstone getter must return boolean or Boolean");
            }
        }

        private void validateContentTypeField(Field f) {
            if (!f.getType().equals(String.class)) {
                throw new IllegalArgumentException("@RiakContentType field must be a String.");
            }
        }

        private void validateContentTypeMethod(Method m) {
            if (m.getParameterTypes().length == 1) {
                if (!String.class.equals(m.getParameterTypes()[0])) {
                    throw new IllegalArgumentException("@RiakContentType setter must take a String.");
                }
            } else if (m.getParameterTypes().length == 0 && !m.getReturnType().equals(String.class)) {
                throw new IllegalArgumentException("@RiakContentType getter must return a String.");
            }
        }

        private void validateLastModifiedField(Field f) {
            if (!f.getType().equals(Long.class) && !f.getType().equals(Long.TYPE)) {
                throw new IllegalArgumentException("@RiakLastModified field must be a Long or long.");
            }
        }

        private void validateLastModifiedMethod(Method m) {
            Class<?> pType;
            if (m.getParameterTypes().length == 0) {
                throw new IllegalArgumentException("@RiakLastModified can only be applied to a setter method.");
            }
            if (m.getParameterTypes().length == 1 && !(pType = m.getParameterTypes()[0]).equals(Long.class) && !pType.equals(Long.TYPE)) {
                throw new IllegalArgumentException("@RiakLastModified setter must take a long or Long.");
            }
        }

        private void validateVTagField(Field f) {
            if (!f.getType().equals(String.class)) {
                throw new IllegalArgumentException("@RiakVTag field must be a String.");
            }
        }

        private void validateVTagMethod(Method m) {
            Class<?> pType;
            if (m.getParameterTypes().length == 0) {
                throw new IllegalArgumentException("@RiakVTag can only be applied to a setter method.");
            }
            if (m.getParameterTypes().length == 1 && !(pType = m.getParameterTypes()[0]).equals(String.class)) {
                throw new IllegalArgumentException("@RiakVTag setter must take a String.");
            }
        }

        private void validateStringOrByteField(Field f, String annotation) {
            if (!(f.getType().isArray() && f.getType().getComponentType().equals(Byte.TYPE) || f.getType().isAssignableFrom(String.class))) {
                throw new IllegalArgumentException(annotation + " field must be a String or byte[].");
            }
        }

        private void validateStringOrByteMethod(Method m, String annotation) {
            Class<String> rType;
            if (m.getParameterTypes().length == 1) {
                Class<String> pType = m.getParameterTypes()[0];
                if (!(pType.isArray() && pType.getComponentType().equals(Byte.TYPE) || pType.isAssignableFrom(String.class))) {
                    throw new IllegalArgumentException(annotation + " setter must take String or byte[]");
                }
            } else if (!(m.getParameterTypes().length != 0 || (rType = m.getReturnType()).isArray() && rType.getComponentType().equals(Byte.TYPE) || rType.isAssignableFrom(String.class))) {
                throw new IllegalArgumentException(annotation + " getter must return String or byte[]");
            }
        }
    }
}

