/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.convert.reflection;

import com.basho.riak.client.api.annotations.RiakUsermeta;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public class UsermetaMethod {
    private final Method method;
    private final String usermetaDataKey;
    private final MethodType methodType;

    public UsermetaMethod(Method method) {
        this.methodType = this.validateAndGetReturnType(method);
        this.method = method;
        this.usermetaDataKey = method.getAnnotation(RiakUsermeta.class).key();
        if ((this.methodType == MethodType.STRING_GETTER || this.methodType == MethodType.STRING_SETTER) && "".equals(this.usermetaDataKey)) {
            throw new IllegalArgumentException("@RiakUsermeta annotated method must include key: " + method);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public String getUsermetaDataKey() {
        return this.usermetaDataKey;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    private MethodType validateAndGetReturnType(Method m) {
        if (m != null) {
            if (m.getReturnType().equals(Void.TYPE)) {
                Type[] genericParameterTypes = m.getGenericParameterTypes();
                Class<?> t = genericParameterTypes[0];
                if (t instanceof ParameterizedType) {
                    Type[] genericTypes;
                    ParameterizedType pType = (ParameterizedType)((Object)t);
                    if (pType.getRawType().equals(Map.class) && String.class.equals((Object)(genericTypes = pType.getActualTypeArguments())[0]) && String.class.equals((Object)genericTypes[1])) {
                        return MethodType.MAP_SETTER;
                    }
                } else {
                    t = m.getParameterTypes()[0];
                    if (t.equals(String.class)) {
                        return MethodType.STRING_SETTER;
                    }
                }
                throw new IllegalArgumentException("@RiakUsermeta setter must take a Map<String,String> or String: " + m);
            }
            Type t = m.getGenericReturnType();
            if (t instanceof ParameterizedType) {
                Type[] genericTypes;
                ParameterizedType pType = (ParameterizedType)t;
                if (pType.getRawType().equals(Map.class) && String.class.equals((Object)(genericTypes = pType.getActualTypeArguments())[0]) && String.class.equals((Object)genericTypes[1])) {
                    return MethodType.MAP_GETTER;
                }
            } else if (m.getReturnType().equals(String.class)) {
                return MethodType.STRING_GETTER;
            }
            throw new IllegalArgumentException("@RiakUsermeta getter must return a Map<String,String> or String: " + m);
        }
        throw new IllegalArgumentException("Method can not be null.");
    }

    public static enum MethodType {
        STRING_GETTER,
        STRING_SETTER,
        MAP_GETTER,
        MAP_SETTER;

    }
}

