/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.netty;

import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.RiakResponseListener;
import com.basho.riak.client.core.netty.RiakResponseException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.basho.riak.protobuf.RiakPB;

public class RiakResponseHandler
extends ChannelInboundHandlerAdapter {
    private RiakResponseListener listener;
    private final Logger logger = LoggerFactory.getLogger(RiakResponseHandler.class);

    public RiakResponseHandler(RiakResponseListener listener) {
        this.listener = listener;
    }

    public void channelRead(ChannelHandlerContext chc, Object message) throws Exception {
        RiakMessage riakMessage = (RiakMessage)message;
        if (riakMessage.getCode() == 0) {
            RiakPB.RpbErrorResp error = RiakPB.RpbErrorResp.parseFrom(riakMessage.getData());
            this.listener.onRiakErrorResponse(chc.channel(), new RiakResponseException(error.getErrcode(), error.getErrmsg().toStringUtf8()));
        } else {
            this.listener.onSuccess(chc.channel(), riakMessage);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.listener.onException(ctx.channel(), cause);
        ctx.close();
    }
}

