/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.converters.BucketPropertiesConverter;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.query.BucketProperties;
import com.basho.riak.client.core.query.Namespace;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakPB;
import shaded.com.google.protobuf.ByteString;
import shaded.com.google.protobuf.InvalidProtocolBufferException;

public class FetchBucketPropsOperation
extends FutureOperation<Response, RiakPB.RpbGetBucketResp, Namespace> {
    private final RiakPB.RpbGetBucketReq.Builder reqBuilder;
    private final Namespace namespace;

    public FetchBucketPropsOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.namespace = builder.namespace;
    }

    @Override
    protected Response convert(List<RiakPB.RpbGetBucketResp> rawResponse) {
        RiakPB.RpbBucketProps pbProps = rawResponse.get(0).getProps();
        return new Response(BucketPropertiesConverter.convert(pbProps));
    }

    @Override
    protected RiakMessage createChannelMessage() {
        RiakPB.RpbGetBucketReq req = this.reqBuilder.build();
        return new RiakMessage(19, req.toByteArray());
    }

    @Override
    protected RiakPB.RpbGetBucketResp decode(RiakMessage rawMessage) {
        Operations.checkMessageType(rawMessage, (byte)20);
        try {
            return RiakPB.RpbGetBucketResp.parseFrom(rawMessage.getData());
        }
        catch (InvalidProtocolBufferException ex) {
            throw new IllegalArgumentException("Invalid message received", ex);
        }
    }

    @Override
    public Namespace getQueryInfo() {
        return this.namespace;
    }

    public static class Response {
        private final BucketProperties props;

        private Response(BucketProperties props) {
            this.props = props;
        }

        public BucketProperties getBucketProperties() {
            return this.props;
        }
    }

    public static class Builder {
        private final RiakPB.RpbGetBucketReq.Builder reqBuilder = RiakPB.RpbGetBucketReq.newBuilder();
        private final Namespace namespace;

        public Builder(Namespace namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace cannot be null");
            }
            this.reqBuilder.setBucket(ByteString.copyFrom(namespace.getBucketName().unsafeGetValue()));
            this.reqBuilder.setType(ByteString.copyFrom(namespace.getBucketType().unsafeGetValue()));
            this.namespace = namespace;
        }

        public FetchBucketPropsOperation build() {
            return new FetchBucketPropsOperation(this);
        }
    }
}

