/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.ArrayList;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakKvPB;
import shaded.com.basho.riak.protobuf.RiakPB;
import shaded.com.google.protobuf.ByteString;
import shaded.com.google.protobuf.InvalidProtocolBufferException;

public class SecondaryIndexQueryOperation
extends FutureOperation<Response, RiakKvPB.RpbIndexResp, Query> {
    private final RiakKvPB.RpbIndexReq pbReq;
    private final Query query;

    private SecondaryIndexQueryOperation(Builder builder) {
        builder.pbReqBuilder.setStream(true);
        this.query = builder.query;
        this.pbReq = builder.pbReqBuilder.build();
    }

    @Override
    protected Response convert(List<RiakKvPB.RpbIndexResp> rawResponse) {
        Response.Builder responseBuilder = new Response.Builder();
        for (RiakKvPB.RpbIndexResp pbEntry : rawResponse) {
            if (this.pbReq.getReturnTerms() && !this.query.indexName.toString().equalsIgnoreCase("$key")) {
                if (this.pbReq.hasRangeMin()) {
                    for (RiakPB.RpbPair pair : pbEntry.getResultsList()) {
                        responseBuilder.addEntry(new Response.Entry(BinaryValue.unsafeCreate(pair.getKey().toByteArray()), BinaryValue.unsafeCreate(pair.getValue().toByteArray())));
                    }
                } else {
                    for (ByteString objKey : pbEntry.getKeysList()) {
                        responseBuilder.addEntry(new Response.Entry(BinaryValue.unsafeCreate(this.pbReq.getKey().toByteArray()), BinaryValue.unsafeCreate(objKey.toByteArray())));
                    }
                }
            } else {
                for (ByteString objKey : pbEntry.getKeysList()) {
                    responseBuilder.addEntry(new Response.Entry(BinaryValue.unsafeCreate(objKey.toByteArray())));
                }
            }
            if (!pbEntry.hasContinuation()) continue;
            responseBuilder.withContinuation(BinaryValue.unsafeCreate(pbEntry.getContinuation().toByteArray()));
        }
        return responseBuilder.build();
    }

    @Override
    protected RiakMessage createChannelMessage() {
        return new RiakMessage(25, this.pbReq.toByteArray());
    }

    @Override
    protected RiakKvPB.RpbIndexResp decode(RiakMessage rawMessage) {
        try {
            Operations.checkMessageType(rawMessage, (byte)26);
            return RiakKvPB.RpbIndexResp.parseFrom(rawMessage.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Invalid message received", e);
        }
    }

    @Override
    protected boolean done(RiakKvPB.RpbIndexResp msg) {
        return msg.getDone();
    }

    @Override
    public Query getQueryInfo() {
        return this.query;
    }

    public static class Response {
        private final BinaryValue continuation;
        private final List<Entry> entryList;

        private Response(Builder builder) {
            this.continuation = builder.continuation;
            this.entryList = builder.entryList;
        }

        public boolean hasContinuation() {
            return this.continuation != null;
        }

        public BinaryValue getContinuation() {
            return this.continuation;
        }

        public List<Entry> getEntryList() {
            return this.entryList;
        }

        static class Builder {
            private BinaryValue continuation;
            private List<Entry> entryList = new ArrayList<Entry>();

            Builder() {
            }

            Builder withContinuation(BinaryValue continuation) {
                this.continuation = continuation;
                return this;
            }

            Builder addEntry(Entry entry) {
                this.entryList.add(entry);
                return this;
            }

            Response build() {
                return new Response(this);
            }
        }

        public static class Entry {
            private final BinaryValue indexKey;
            private final BinaryValue objectKey;

            Entry(BinaryValue objectKey) {
                this(null, objectKey);
            }

            Entry(BinaryValue indexKey, BinaryValue objectKey) {
                this.indexKey = indexKey;
                this.objectKey = objectKey;
            }

            public boolean hasIndexKey() {
                return this.indexKey != null;
            }

            public BinaryValue getIndexKey() {
                return this.indexKey;
            }

            public BinaryValue getObjectKey() {
                return this.objectKey;
            }
        }
    }

    public static class Query {
        private final Namespace namespace;
        private final BinaryValue indexName;
        private final BinaryValue indexKey;
        private final BinaryValue rangeStart;
        private final BinaryValue rangeEnd;
        private final boolean returnKeyAndIndex;
        private final Integer maxResults;
        private final BinaryValue continuation;
        private final Boolean paginationSort;
        private final BinaryValue termFilter;
        private final Integer timeout;

        private Query(Builder builder) {
            this.indexName = builder.indexName;
            this.indexKey = builder.indexKey;
            this.rangeStart = builder.rangeStart;
            this.rangeEnd = builder.rangeEnd;
            this.returnKeyAndIndex = builder.returnKeyAndIndex;
            this.maxResults = builder.maxResults;
            this.continuation = builder.continuation;
            this.paginationSort = builder.paginationSort;
            this.termFilter = builder.termFilter;
            this.namespace = builder.namespace;
            this.timeout = builder.timeout;
        }

        public Namespace getNamespace() {
            return this.namespace;
        }

        public BinaryValue getIndexName() {
            return this.indexName;
        }

        public BinaryValue getIndexKey() {
            return this.indexKey;
        }

        public BinaryValue getRangeStart() {
            return this.rangeStart;
        }

        public BinaryValue getRangeEnd() {
            return this.rangeEnd;
        }

        public boolean isReturnKeyAndIndex() {
            return this.returnKeyAndIndex;
        }

        public int getMaxResults() {
            return this.maxResults;
        }

        public BinaryValue getContinuation() {
            return this.continuation;
        }

        public boolean isPaginationSort() {
            return this.paginationSort;
        }

        public BinaryValue getTermFilter() {
            return this.termFilter;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public static class Builder {
            private final Namespace namespace;
            private final BinaryValue indexName;
            private BinaryValue indexKey;
            private BinaryValue rangeStart;
            private BinaryValue rangeEnd;
            private boolean returnKeyAndIndex;
            private Integer maxResults;
            private BinaryValue continuation;
            private Boolean paginationSort;
            private BinaryValue termFilter;
            private Integer timeout;

            public Builder(Namespace namespace, BinaryValue indexName) {
                if (namespace == null) {
                    throw new IllegalArgumentException("Namespace cannot be null");
                }
                if (null == indexName || indexName.length() == 0) {
                    throw new IllegalArgumentException("Index name cannot be null or zero length");
                }
                this.indexName = indexName;
                this.namespace = namespace;
            }

            public Builder withIndexKey(BinaryValue key) {
                this.indexKey = key;
                return this;
            }

            public Builder withRangeStart(BinaryValue startingIndex) {
                this.rangeStart = startingIndex;
                return this;
            }

            public Builder withRangeEnd(BinaryValue endIndex) {
                this.rangeEnd = endIndex;
                return this;
            }

            public Builder withReturnKeyAndIndex(boolean returnBoth) {
                this.returnKeyAndIndex = returnBoth;
                return this;
            }

            public Builder withMaxResults(int maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Builder withContinuation(BinaryValue continuation) {
                this.continuation = continuation;
                return this;
            }

            public Builder withPaginationSort(boolean orderByKey) {
                this.paginationSort = orderByKey;
                return this;
            }

            public Builder withRegexTermFilter(BinaryValue filter) {
                this.termFilter = filter;
                return this;
            }

            public Builder withTimeout(int timeout) {
                this.timeout = timeout;
                return this;
            }

            public Query build() {
                if (this.rangeStart == null && this.rangeEnd == null && this.indexKey == null) {
                    throw new IllegalArgumentException("An index key or range must be supplied");
                }
                if (this.rangeStart != null && this.rangeEnd == null || this.rangeEnd != null && this.rangeStart == null) {
                    throw new IllegalArgumentException("When specifying ranges both start and end must be Set");
                }
                if (this.rangeStart != null && this.indexKey != null) {
                    throw new IllegalArgumentException("Cannot specify single index key and range");
                }
                if (this.maxResults != null && this.paginationSort != null && !this.paginationSort.booleanValue()) {
                    throw new IllegalArgumentException("Cannot set paginationSort=false while setting maxResults");
                }
                if (this.termFilter != null && this.indexName.toStringUtf8().endsWith("_int")) {
                    throw new IllegalArgumentException("Cannot use term regular expression in integer query");
                }
                return new Query(this);
            }
        }
    }

    public static class Builder {
        private final RiakKvPB.RpbIndexReq.Builder pbReqBuilder = RiakKvPB.RpbIndexReq.newBuilder();
        private final Query query;

        public Builder(Query query) {
            if (query == null) {
                throw new IllegalArgumentException("Query cannot be null.");
            }
            this.query = query;
            this.pbReqBuilder.setBucket(ByteString.copyFrom(query.namespace.getBucketName().unsafeGetValue())).setType(ByteString.copyFrom(query.namespace.getBucketType().unsafeGetValue())).setIndex(ByteString.copyFrom(query.indexName.unsafeGetValue())).setReturnTerms(query.returnKeyAndIndex);
            if (query.indexKey != null) {
                this.pbReqBuilder.setKey(ByteString.copyFrom(query.indexKey.unsafeGetValue())).setQtype(RiakKvPB.RpbIndexReq.IndexQueryType.eq);
            } else {
                this.pbReqBuilder.setRangeMin(ByteString.copyFrom(query.rangeStart.unsafeGetValue())).setRangeMax(ByteString.copyFrom(query.rangeEnd.unsafeGetValue())).setQtype(RiakKvPB.RpbIndexReq.IndexQueryType.range);
            }
            if (query.maxResults != null) {
                this.pbReqBuilder.setMaxResults(query.maxResults);
            }
            if (query.continuation != null) {
                this.pbReqBuilder.setContinuation(ByteString.copyFrom(query.continuation.unsafeGetValue()));
            }
            if (query.paginationSort != null) {
                this.pbReqBuilder.setPaginationSort(query.paginationSort);
            }
            if (query.termFilter != null) {
                this.pbReqBuilder.setTermRegex(ByteString.copyFrom(query.termFilter.unsafeGetValue()));
            }
            if (query.timeout != null) {
                this.pbReqBuilder.setTimeout(query.timeout);
            }
        }

        public SecondaryIndexQueryOperation build() {
            return new SecondaryIndexQueryOperation(this);
        }
    }
}

