/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.operations.PBFutureOperation;
import com.basho.riak.client.core.query.timeseries.PbResultFactory;
import com.basho.riak.client.core.query.timeseries.TableDefinition;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;
import shaded.com.google.protobuf.ByteString;

public class DescribeTableOperation
extends PBFutureOperation<TableDefinition, RiakTsPB.TsQueryResp, String> {
    private final String tableName;
    private final String queryText;

    public DescribeTableOperation(String tableName) {
        this(new Builder(tableName));
    }

    private DescribeTableOperation(Builder builder) {
        super((byte)90, (byte)91, RiakTsPB.TsQueryReq.newBuilder().setQuery(builder.interpolationBuilder), RiakTsPB.TsQueryResp.PARSER);
        this.queryText = builder.queryText;
        this.tableName = builder.tableName;
    }

    @Override
    protected TableDefinition convert(List<RiakTsPB.TsQueryResp> responses) {
        RiakTsPB.TsQueryResp response = this.checkAndGetSingleResponse(responses);
        return PbResultFactory.convertDescribeResp(this.tableName, response);
    }

    @Override
    public String getQueryInfo() {
        return this.queryText;
    }

    public static class Builder {
        private final String tableName;
        private final String queryText;
        private final RiakTsPB.TsInterpolation.Builder interpolationBuilder = RiakTsPB.TsInterpolation.newBuilder();

        public Builder(String tableName) {
            if (tableName == null || tableName.length() == 0) {
                throw new IllegalArgumentException("Table Name cannot be null or empty");
            }
            this.tableName = tableName;
            this.queryText = String.format("DESCRIBE %s", tableName);
            this.interpolationBuilder.setBase(ByteString.copyFromUtf8(this.queryText));
        }

        public DescribeTableOperation build() {
            return new DescribeTableOperation(this);
        }
    }
}

