/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.operations.PBFutureOperation;
import com.basho.riak.client.core.query.timeseries.Cell;
import com.basho.riak.client.core.query.timeseries.ConvertibleIterable;
import com.basho.riak.client.core.query.timeseries.PbResultFactory;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;
import shaded.com.google.protobuf.ByteString;

public class FetchOperation
extends PBFutureOperation<QueryResult, RiakTsPB.TsGetResp, String> {
    private final Builder builder;
    private String queryInfoMessage;

    private FetchOperation(Builder builder) {
        super((byte)96, (byte)97, builder.reqBuilder, RiakTsPB.TsGetResp.PARSER);
        this.builder = builder;
    }

    @Override
    protected QueryResult convert(List<RiakTsPB.TsGetResp> responses) {
        RiakTsPB.TsGetResp response = this.checkAndGetSingleResponse(responses);
        return PbResultFactory.convertPbGetResp(response);
    }

    @Override
    public String getQueryInfo() {
        if (this.queryInfoMessage == null) {
            this.queryInfoMessage = this.createQueryInfoMessage();
        }
        return this.queryInfoMessage;
    }

    private String createQueryInfoMessage() {
        StringBuilder sb = new StringBuilder();
        for (Cell cell : this.builder.keyValues) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(cell == null ? "NULL" : cell.toString());
        }
        return String.format("SELECT * FROM %s WHERE PRIMARY KEY = { %s }", this.builder.tableName, sb.toString());
    }

    public static class Builder {
        private final String tableName;
        private final Iterable<Cell> keyValues;
        private final RiakTsPB.TsGetReq.Builder reqBuilder = RiakTsPB.TsGetReq.newBuilder();

        public Builder(String tableName, Iterable<Cell> keyValues) {
            if (tableName == null || tableName.length() == 0) {
                throw new IllegalArgumentException("Table Name cannot be null or an empty string.");
            }
            if (keyValues == null || !keyValues.iterator().hasNext()) {
                throw new IllegalArgumentException("Key Values cannot be null or an empty.");
            }
            this.reqBuilder.setTable(ByteString.copyFromUtf8(tableName));
            this.reqBuilder.addAllKey(ConvertibleIterable.asIterablePbCell(keyValues));
            this.tableName = tableName;
            this.keyValues = keyValues;
        }

        public Builder withTimeout(int timeout) {
            this.reqBuilder.setTimeout(timeout);
            return this;
        }

        public FetchOperation build() {
            return new FetchOperation(this);
        }
    }
}

