/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.crdt.types;

import com.basho.riak.client.core.query.crdt.types.RiakCounter;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.query.crdt.types.RiakFlag;
import com.basho.riak.client.core.query.crdt.types.RiakRegister;
import com.basho.riak.client.core.query.crdt.types.RiakSet;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RiakMap
extends RiakDatatype {
    private final Map<BinaryValue, List<RiakDatatype>> entries = new HashMap<BinaryValue, List<RiakDatatype>>();

    public RiakMap(List<MapEntry> mapEntries) {
        for (MapEntry entry : mapEntries) {
            List<RiakDatatype> datatypes = this.entries.get(entry.field);
            if (datatypes == null) {
                datatypes = new LinkedList<RiakDatatype>();
                this.entries.put(entry.field, datatypes);
            }
            datatypes.add(entry.element);
        }
    }

    public List<RiakDatatype> get(BinaryValue key) {
        return this.entries.get(key);
    }

    public RiakMap getMap(BinaryValue key) {
        if (this.entries.containsKey(key)) {
            for (RiakDatatype dt : this.entries.get(key)) {
                if (!dt.isMap()) continue;
                return dt.getAsMap();
            }
        }
        return null;
    }

    public RiakMap getMap(String key) {
        return this.getMap(BinaryValue.create(key));
    }

    public RiakSet getSet(BinaryValue key) {
        if (this.entries.containsKey(key)) {
            for (RiakDatatype dt : this.entries.get(key)) {
                if (!dt.isSet()) continue;
                return dt.getAsSet();
            }
        }
        return null;
    }

    public RiakSet getSet(String key) {
        return this.getSet(BinaryValue.create(key));
    }

    public RiakCounter getCounter(BinaryValue key) {
        if (this.entries.containsKey(key)) {
            for (RiakDatatype dt : this.entries.get(key)) {
                if (!dt.isCounter()) continue;
                return dt.getAsCounter();
            }
        }
        return null;
    }

    public RiakCounter getCounter(String key) {
        return this.getCounter(BinaryValue.create(key));
    }

    public RiakFlag getFlag(BinaryValue key) {
        if (this.entries.containsKey(key)) {
            for (RiakDatatype dt : this.entries.get(key)) {
                if (!dt.isFlag()) continue;
                return dt.getAsFlag();
            }
        }
        return null;
    }

    public RiakFlag getFlag(String key) {
        return this.getFlag(BinaryValue.create(key));
    }

    public RiakRegister getRegister(BinaryValue key) {
        if (this.entries.containsKey(key)) {
            for (RiakDatatype dt : this.entries.get(key)) {
                if (!dt.isRegister()) continue;
                return dt.getAsRegister();
            }
        }
        return null;
    }

    public RiakRegister getRegister(String key) {
        return this.getRegister(BinaryValue.create(key));
    }

    @Override
    public Map<BinaryValue, List<RiakDatatype>> view() {
        return Collections.unmodifiableMap(this.entries);
    }

    public static final class MapEntry {
        private final BinaryValue field;
        private final RiakDatatype element;

        public MapEntry(BinaryValue field, RiakDatatype element) {
            this.field = field;
            this.element = element;
        }

        public BinaryValue getField() {
            return this.field;
        }

        public RiakDatatype getElement() {
            return this.element;
        }
    }
}

