/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.functions;

public class Function {
    private final boolean isJavascript;
    private final String name;
    private final String bucket;
    private final String key;
    private final String source;
    private final String module;
    private final String function;

    private Function(Builder builder) {
        switch (builder.type) {
            case NAMED_JS: 
            case STORED_JS: 
            case ANON_JS: {
                this.isJavascript = true;
                break;
            }
            default: {
                this.isJavascript = false;
            }
        }
        this.name = builder.name;
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.source = builder.source;
        this.module = builder.module;
        this.function = builder.function;
    }

    public boolean isJavascript() {
        return this.isJavascript;
    }

    public boolean isNamed() {
        return this.name != null;
    }

    public boolean isStored() {
        return this.bucket != null;
    }

    public boolean isAnonymous() {
        return this.source != null;
    }

    public String getName() {
        return this.name;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getSource() {
        return this.source;
    }

    public String getModule() {
        return this.module;
    }

    public String getFunction() {
        return this.function;
    }

    public static Function newNamedJsFunction(String name) {
        return new Builder().withName(name).build();
    }

    public static Function newStoredJsFunction(String bucket, String key) {
        return new Builder().withBucket(bucket).withKey(key).build();
    }

    public static Function newAnonymousJsFunction(String source) {
        return new Builder().withSource(source).build();
    }

    public static Function newErlangFunction(String module, String function) {
        return new Builder().withModule(module).withFunction(function).build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (null == this.name ? 0 : this.name.hashCode());
        result = 31 * result + (null == this.bucket ? 0 : this.bucket.hashCode());
        result = 31 * result + (null == this.key ? 0 : this.key.hashCode());
        result = 31 * result + (null == this.source ? 0 : this.source.hashCode());
        result = 31 * result + (null == this.module ? 0 : this.module.hashCode());
        result = 31 * result + (null == this.function ? 0 : this.function.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Function)) {
            return false;
        }
        Function other = (Function)obj;
        return (this.name == other.name || this.name != null && this.name.equals(other.name)) && (this.bucket == other.bucket || this.bucket != null && this.bucket.equals(other.bucket)) && (this.key == other.key || this.key != null && this.key.equals(other.key)) && (this.source == other.source || this.source != null && this.source.equals(other.source)) && (this.module == other.module || this.module != null && this.module.equals(other.module)) && (this.function == other.function || this.function != null && this.function.equals(other.function));
    }

    public static class Builder {
        private Type type = Type.UNKNOWN;
        private String name;
        private String bucket;
        private String key;
        private String source;
        private String module;
        private String function;

        public Builder withName(String name) {
            this.stringCheck(name);
            switch (this.type) {
                case NAMED_JS: 
                case UNKNOWN: {
                    this.name = name;
                    this.type = Type.NAMED_JS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)this.type) + " can not have a name.");
                }
            }
            return this;
        }

        public Builder withBucket(String bucket) {
            this.stringCheck(bucket);
            switch (this.type) {
                case STORED_JS: 
                case UNKNOWN: {
                    this.bucket = bucket;
                    this.type = Type.STORED_JS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)this.type) + " can not have a bucket.");
                }
            }
            return this;
        }

        public Builder withKey(String key) {
            this.stringCheck(key);
            switch (this.type) {
                case STORED_JS: 
                case UNKNOWN: {
                    this.key = key;
                    this.type = Type.STORED_JS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)this.type) + " can not have a key.");
                }
            }
            return this;
        }

        public Builder withSource(String source) {
            this.stringCheck(source);
            switch (this.type) {
                case UNKNOWN: {
                    this.source = source;
                    this.type = Type.ANON_JS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)this.type) + " can not have a source.");
                }
            }
            return this;
        }

        public Builder withModule(String module) {
            this.stringCheck(module);
            switch (this.type) {
                case UNKNOWN: 
                case ERLANG: {
                    this.module = module;
                    this.type = Type.ERLANG;
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)this.type) + " can not have a module.");
                }
            }
            return this;
        }

        public Builder withFunction(String function) {
            this.stringCheck(function);
            switch (this.type) {
                case UNKNOWN: 
                case ERLANG: {
                    this.function = function;
                    this.type = Type.ERLANG;
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)this.type) + " can not have a function.");
                }
            }
            return this;
        }

        private void stringCheck(String arg) {
            if (null == arg || arg.length() == 0) {
                throw new IllegalArgumentException("String can not be null or zero length.");
            }
        }

        public Function build() {
            switch (this.type) {
                case UNKNOWN: {
                    throw new IllegalStateException("Nothing to build.");
                }
                case STORED_JS: {
                    if (null != this.bucket && null != this.key) break;
                    throw new IllegalArgumentException("Stored Javascript requires both a bucket and key");
                }
                case ERLANG: {
                    if (null != this.module && null != this.function) break;
                    throw new IllegalArgumentException("Erlang requires both a module and a function");
                }
            }
            return new Function(this);
        }

        private static enum Type {
            UNKNOWN,
            NAMED_JS,
            STORED_JS,
            ANON_JS,
            ERLANG;

        }
    }
}

