/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.indexes;

public enum IndexType {
    INT("_int"),
    BIN("_bin"),
    BUCKET(""),
    KEY("");

    private final String suffix;

    private IndexType(String suffix) {
        this.suffix = suffix;
    }

    public String suffix() {
        return this.suffix;
    }

    public static IndexType typeFromFullname(String fullname) {
        if (fullname.equalsIgnoreCase("$bucket")) {
            return BUCKET;
        }
        if (fullname.equalsIgnoreCase("$key")) {
            return KEY;
        }
        int i = fullname.lastIndexOf(95);
        if (i != -1) {
            String suffix = fullname.substring(i);
            for (IndexType t : IndexType.values()) {
                if (!t.suffix().equalsIgnoreCase(suffix)) continue;
                return t;
            }
        }
        throw new IllegalArgumentException("Indexname does not end with valid suffix");
    }
}

