/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.indexes;

import com.basho.riak.client.core.query.indexes.IndexType;
import com.basho.riak.client.core.query.indexes.RiakIndex;
import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.client.core.util.DefaultCharset;
import java.nio.charset.Charset;

public class StringBinIndex
extends RiakIndex<String> {
    private final Charset charset;

    private StringBinIndex(Name name) {
        super(name);
        this.charset = name.charset;
    }

    @Override
    protected BinaryValue convert(String value) {
        return BinaryValue.unsafeCreate(value.getBytes(this.charset));
    }

    @Override
    protected String convert(BinaryValue value) {
        return value.toString(this.charset);
    }

    public static Name named(String name) {
        return StringBinIndex.named(name, DefaultCharset.get());
    }

    public static Name named(String name, Charset charset) {
        return new Name(name, charset);
    }

    public static class Name
    extends RiakIndex.Name<StringBinIndex> {
        private final Charset charset;

        Name(String name) {
            this(name, DefaultCharset.get());
        }

        Name(String name, Charset charset) {
            super(name, IndexType.BIN);
            this.charset = charset;
        }

        @Override
        StringBinIndex createIndex() {
            return new StringBinIndex(this);
        }
    }
}

