/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.util.BinaryValue;
import java.util.Calendar;
import java.util.Date;
import shaded.com.basho.riak.protobuf.RiakTsPB;
import shaded.com.google.protobuf.ByteString;

public class Cell {
    static final Cell NullCell = new Cell(RiakTsPB.TsCell.newBuilder().build());
    private final RiakTsPB.TsCell pbCell;

    public Cell(String varcharValue) {
        if (varcharValue == null) {
            throw new IllegalArgumentException("String value cannot be NULL.");
        }
        ByteString varcharByteString = ByteString.copyFromUtf8(varcharValue);
        this.pbCell = RiakTsPB.TsCell.newBuilder().setVarcharValue(varcharByteString).build();
    }

    public Cell(BinaryValue varcharValue) {
        if (varcharValue == null) {
            throw new IllegalArgumentException("BinaryValue value cannot be NULL.");
        }
        ByteString varcharByteString = ByteString.copyFrom(varcharValue.getValue());
        this.pbCell = RiakTsPB.TsCell.newBuilder().setVarcharValue(varcharByteString).build();
    }

    public Cell(long sint64Value) {
        this.pbCell = RiakTsPB.TsCell.newBuilder().setSint64Value(sint64Value).build();
    }

    public Cell(double doubleValue) {
        this.pbCell = RiakTsPB.TsCell.newBuilder().setDoubleValue(doubleValue).build();
    }

    public Cell(boolean booleanValue) {
        this.pbCell = RiakTsPB.TsCell.newBuilder().setBooleanValue(booleanValue).build();
    }

    public Cell(Calendar timestampValue) {
        if (timestampValue == null) {
            throw new IllegalArgumentException("Calendar object for timestamp value cannot be NULL.");
        }
        this.pbCell = RiakTsPB.TsCell.newBuilder().setTimestampValue(timestampValue.getTimeInMillis()).build();
    }

    public Cell(Date timestampValue) {
        if (timestampValue == null) {
            throw new IllegalArgumentException("Date object for timestamp value cannot be NULL.");
        }
        this.pbCell = RiakTsPB.TsCell.newBuilder().setTimestampValue(timestampValue.getTime()).build();
    }

    Cell(RiakTsPB.TsCell pbCell) {
        this.pbCell = pbCell;
    }

    public static Cell newTimestamp(long rawTimestampValue) {
        RiakTsPB.TsCell tsCell = RiakTsPB.TsCell.newBuilder().setTimestampValue(rawTimestampValue).build();
        return new Cell(tsCell);
    }

    public boolean hasVarcharValue() {
        return this.pbCell.hasVarcharValue();
    }

    public boolean hasLong() {
        return this.pbCell.hasSint64Value();
    }

    public boolean hasTimestamp() {
        return this.pbCell.hasTimestampValue();
    }

    public boolean hasBoolean() {
        return this.pbCell.hasBooleanValue();
    }

    public boolean hasDouble() {
        return this.pbCell.hasDoubleValue();
    }

    public String getVarcharAsUTF8String() {
        return this.pbCell.getVarcharValue().toStringUtf8();
    }

    public BinaryValue getVarcharValue() {
        return BinaryValue.unsafeCreate(this.pbCell.getVarcharValue().toByteArray());
    }

    public long getLong() {
        return this.pbCell.getSint64Value();
    }

    public double getDouble() {
        return this.pbCell.getDoubleValue();
    }

    public long getTimestamp() {
        return this.pbCell.getTimestampValue();
    }

    public boolean getBoolean() {
        return this.pbCell.getBooleanValue();
    }

    RiakTsPB.TsCell getPbCell() {
        return this.pbCell;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Cell{ ");
        if (this.hasVarcharValue()) {
            String value = this.getVarcharAsUTF8String();
            if (value.length() > 32) {
                sb.append(value.substring(0, 32));
                sb.append("...");
            } else {
                sb.append(value);
            }
        } else if (this.hasLong()) {
            sb.append(this.getLong());
        } else if (this.hasDouble()) {
            sb.append(this.getDouble());
        } else if (this.hasTimestamp()) {
            sb.append(this.getTimestamp());
        } else if (this.hasBoolean()) {
            sb.append(this.getBoolean());
        }
        sb.append(" }");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        return !(this.pbCell == null ? cell.pbCell != null : !this.pbCell.equals(cell.pbCell));
    }

    public int hashCode() {
        return this.pbCell != null ? this.pbCell.hashCode() : 0;
    }
}

