/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.Cell;
import com.basho.riak.client.core.query.timeseries.Row;
import java.util.Iterator;
import shaded.com.basho.riak.protobuf.RiakTsPB;

public abstract class ConvertibleIterator<S, D>
implements Iterator<D> {
    private final Iterator<S> iterator;

    public ConvertibleIterator(Iterator<S> iterator) {
        this.iterator = iterator;
    }

    protected abstract D convert(S var1);

    @Override
    public final boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public final D next() {
        return this.convert(this.iterator.next());
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public static ConvertibleIterator<Row, RiakTsPB.TsRow> iterateAsPbRow(Iterator<Row> iterator) {
        return new ImmutablePBRowIterator(iterator);
    }

    public static ConvertibleIterator<RiakTsPB.TsRow, Row> iterateAsRow(Iterator<RiakTsPB.TsRow> iterator) {
        return new ImmutableRowIterator(iterator);
    }

    public static ConvertibleIterator<Cell, RiakTsPB.TsCell> iterateAsPbCell(Iterator<Cell> iterator) {
        return new ImmutablePBCellIterator(iterator);
    }

    public static ConvertibleIterator<RiakTsPB.TsCell, Cell> iterateAsCell(Iterator<RiakTsPB.TsCell> iterator) {
        return new ImmutableCellIterator(iterator);
    }

    private static class ImmutableRowIterator
    extends ConvertibleIterator<RiakTsPB.TsRow, Row> {
        public ImmutableRowIterator(Iterator<RiakTsPB.TsRow> iterator) {
            super(iterator);
        }

        @Override
        protected Row convert(RiakTsPB.TsRow source) {
            return new Row(source);
        }
    }

    private static class ImmutableCellIterator
    extends ConvertibleIterator<RiakTsPB.TsCell, Cell> {
        public ImmutableCellIterator(Iterator<RiakTsPB.TsCell> iterator) {
            super(iterator);
        }

        @Override
        protected Cell convert(RiakTsPB.TsCell pbCell) {
            if (pbCell.equals(Cell.NullCell.getPbCell())) {
                return null;
            }
            return new Cell(pbCell);
        }
    }

    private static class ImmutablePBRowIterator
    extends ConvertibleIterator<Row, RiakTsPB.TsRow> {
        public ImmutablePBRowIterator(Iterator<Row> iterator) {
            super(iterator);
        }

        @Override
        protected RiakTsPB.TsRow convert(Row row) {
            return row.getPbRow();
        }
    }

    private static class ImmutablePBCellIterator
    extends ConvertibleIterator<Cell, RiakTsPB.TsCell> {
        public ImmutablePBCellIterator(Iterator<Cell> iterator) {
            super(iterator);
        }

        @Override
        protected RiakTsPB.TsCell convert(Cell cell) {
            if (cell == null) {
                return Cell.NullCell.getPbCell();
            }
            return cell.getPbCell();
        }
    }
}

