/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class FlatteningIterable<O, I>
implements Iterable<I> {
    private final Iterable<O> source;
    private final InnerIterableProvider<O, I> innerIterableProvider;

    public FlatteningIterable(Iterable<O> source, InnerIterableProvider<O, I> innerIterableProvider) {
        this.source = source;
        this.innerIterableProvider = innerIterableProvider;
    }

    @Override
    public Iterator<I> iterator() {
        return new FlatteningIterator<O, I>(this.source.iterator(), this.innerIterableProvider);
    }

    private static class FlatteningIterator<O, I>
    implements Iterator<I> {
        private final Iterator<O> iteratorSource;
        private final InnerIterableProvider<O, I> innerIterableProvider;
        private Iterator<I> currentIterator = null;

        public FlatteningIterator(Iterator<O> source, InnerIterableProvider<O, I> innerIterableProvider) {
            this.iteratorSource = source;
            this.innerIterableProvider = innerIterableProvider;
            this.loadNextIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.currentIteratorHasMore()) {
                return true;
            }
            if (this.currentIteratorIsEmptyButSourceHasMore()) {
                this.loadNextIterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public I next() {
            if (this.currentIteratorHasMore()) {
                return this.currentIterator.next();
            }
            if (this.currentIteratorIsEmptyButSourceHasMore()) {
                this.loadNextIterator();
                return this.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean currentIteratorHasMore() {
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        private boolean currentIteratorIsEmptyButSourceHasMore() {
            return this.currentIterator != null && !this.currentIterator.hasNext() && this.iteratorSource.hasNext();
        }

        private void loadNextIterator() {
            this.currentIterator = this.iteratorSource.hasNext() ? this.innerIterableProvider.getInnerIterator(this.iteratorSource.next()) : null;
        }
    }

    public static interface InnerIterableProvider<O, I> {
        public Iterator<I> getInnerIterator(O var1);
    }
}

