/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharsetUtils {
    public static Charset ASCII = Charset.forName("ASCII");
    public static Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern CHARSET_PATT = Pattern.compile("\\bcharset *= *\"?([^ ;\"]+)\"?", 2);

    public static Charset getCharset(String contentType) {
        if (contentType == null) {
            return UTF_8;
        }
        if ("application/json; charset=UTF-8".equals(contentType)) {
            return UTF_8;
        }
        Matcher matcher = CHARSET_PATT.matcher(contentType);
        if (matcher.find()) {
            String encstr = matcher.group(1);
            if (encstr.equalsIgnoreCase("UTF-8")) {
                return UTF_8;
            }
            try {
                return Charset.forName(encstr.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ISO_8859_1;
    }

    public static String getDeclaredCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher matcher = CHARSET_PATT.matcher(contentType);
        if (matcher.find()) {
            String encstr = matcher.group(1);
            return encstr;
        }
        return null;
    }

    public static String addUtf8Charset(String contentType) {
        if (contentType == null) {
            return "text/plain;charset=utf-8";
        }
        Matcher matcher = CHARSET_PATT.matcher(contentType);
        if (matcher.find()) {
            return contentType.substring(0, matcher.start(1)) + "utf-8" + contentType.substring(matcher.end(1));
        }
        return contentType + ";charset=utf-8";
    }

    public static String addCharset(String charset, String contentType) {
        if (null == contentType) {
            return "text/plain;charset=" + charset;
        }
        Matcher matcher = CHARSET_PATT.matcher(contentType);
        if (matcher.find()) {
            return contentType.substring(0, matcher.start(1)) + charset + contentType.substring(matcher.end(1));
        }
        return contentType + ";charset=" + charset;
    }

    public static String addCharset(Charset charset, String contentType) {
        return CharsetUtils.addCharset(charset.name(), contentType);
    }

    public static String asString(byte[] bytes, Charset charset) {
        if (bytes == null) {
            return null;
        }
        if (charset == null) {
            throw new IllegalArgumentException("Cannot get bytes without a Charset");
        }
        try {
            return new String(bytes, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(charset.name() + " must be present", e);
        }
    }

    public static String asUTF8String(byte[] bytes) {
        return CharsetUtils.asString(bytes, UTF_8);
    }

    public static String asASCIIString(byte[] bytes) {
        return CharsetUtils.asString(bytes, ASCII);
    }

    public static byte[] asBytes(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        if (charset == null) {
            throw new IllegalArgumentException("Cannot get bytes without a Charset");
        }
        try {
            return string.getBytes(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Charset present", e);
        }
    }

    public static byte[] utf8StringToBytes(String string) {
        return CharsetUtils.asBytes(string, UTF_8);
    }

    public static boolean hasCharset(String ctype) {
        if (ctype == null) {
            return false;
        }
        Matcher matcher = CHARSET_PATT.matcher(ctype);
        return matcher.find();
    }
}

