/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api;

import com.clickhouse.client.api.ClientFaultCause;
import com.clickhouse.client.api.ClientMisconfigurationException;
import com.clickhouse.client.api.ConnectionReuseStrategy;
import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ClientConfigProperties {
    SESSION_DB_ROLES("session_db_roles", List.class),
    SETTING_LOG_COMMENT(ClientConfigProperties.serverSetting("log_comment"), String.class),
    HTTP_USE_BASIC_AUTH("http_use_basic_auth", Boolean.class, "true"),
    USER("user", String.class, "default"),
    PASSWORD("password", String.class),
    HTTP_MAX_OPEN_CONNECTIONS("max_open_connections", Integer.class, "10"),
    HTTP_KEEP_ALIVE_TIMEOUT("http_keep_alive_timeout", Long.class),
    USE_SERVER_TIMEZONE("use_server_time_zone", Boolean.class, "true"),
    USE_TIMEZONE("use_time_zone", TimeZone.class),
    SERVER_VERSION("server_version", String.class),
    SERVER_TIMEZONE("server_time_zone", TimeZone.class, "UTC"),
    ASYNC_OPERATIONS("async", Boolean.class, "false"),
    CONNECTION_TTL("connection_ttl", Long.class, "-1"),
    CONNECTION_TIMEOUT("connection_timeout", Long.class),
    CONNECTION_REUSE_STRATEGY("connection_reuse_strategy", ConnectionReuseStrategy.class, String.valueOf((Object)((Object)ConnectionReuseStrategy.FIFO))),
    SOCKET_OPERATION_TIMEOUT("socket_timeout", Integer.class, "0"),
    SOCKET_RCVBUF_OPT("socket_rcvbuf", Integer.class, "804800"),
    SOCKET_SNDBUF_OPT("socket_sndbuf", Integer.class, "804800"),
    SOCKET_REUSEADDR_OPT("socket_reuseaddr", Boolean.class),
    SOCKET_KEEPALIVE_OPT("socket_keepalive", Boolean.class),
    SOCKET_TCP_NO_DELAY_OPT("socket_tcp_nodelay", Boolean.class),
    SOCKET_LINGER_OPT("socket_linger", Boolean.class),
    DATABASE("database", String.class, "default"),
    COMPRESS_SERVER_RESPONSE("compress", Boolean.class, "true"),
    COMPRESS_CLIENT_REQUEST("decompress", Boolean.class, "false"),
    USE_HTTP_COMPRESSION("client.use_http_compression", Boolean.class, "false"),
    COMPRESSION_LZ4_UNCOMPRESSED_BUF_SIZE("compression.lz4.uncompressed_buffer_size", Integer.class, String.valueOf(65536)),
    DISABLE_NATIVE_COMPRESSION("disable_native_compression", Boolean.class, "false"),
    PROXY_TYPE("proxy_type", String.class),
    PROXY_HOST("proxy_host", String.class),
    PROXY_PORT("proxy_port", Integer.class),
    PROXY_USER("proxy_user", String.class),
    PROXY_PASSWORD("proxy_password", String.class),
    MAX_EXECUTION_TIME("max_execution_time", Integer.class, "0"),
    SSL_TRUST_STORE("trust_store", String.class),
    SSL_KEYSTORE_TYPE("key_store_type", String.class),
    SSL_KEY_STORE("ssl_key_store", String.class),
    SSL_KEY_STORE_PASSWORD("key_store_password", String.class),
    SSL_KEY("ssl_key", String.class),
    CA_CERTIFICATE("sslrootcert", String.class),
    SSL_CERTIFICATE("sslcert", String.class),
    RETRY_ON_FAILURE("retry", Integer.class, "3"),
    INPUT_OUTPUT_FORMAT("format", ClickHouseFormat.class),
    MAX_THREADS_PER_CLIENT("max_threads_per_client", Integer.class, "0"),
    QUERY_ID("query_id", String.class),
    CLIENT_NETWORK_BUFFER_SIZE("client_network_buffer_size", Integer.class, "300000"),
    ACCESS_TOKEN("access_token", String.class),
    SSL_AUTH("ssl_authentication", Boolean.class, "false"),
    CONNECTION_POOL_ENABLED("connection_pool_enabled", Boolean.class, "true"),
    CONNECTION_REQUEST_TIMEOUT("connection_request_timeout", Long.class, "10000"),
    CLIENT_RETRY_ON_FAILURE("client_retry_on_failures", (Class)List.class, String.join((CharSequence)",", ClientFaultCause.NoHttpResponse.name(), ClientFaultCause.ConnectTimeout.name(), ClientFaultCause.ConnectionRequestTimeout.name(), ClientFaultCause.ServerRetryable.name())){

        @Override
        public Object parseValue(String value) {
            List strValues = (List)super.parseValue(value);
            ArrayList<ClientFaultCause> failures = new ArrayList<ClientFaultCause>();
            if (strValues != null) {
                for (String strValue : strValues) {
                    failures.add(ClientFaultCause.valueOf(strValue));
                }
            }
            return failures;
        }
    }
    ,
    CLIENT_NAME("client_name", String.class, ""),
    PRODUCT_NAME("product_name", String.class),
    BEARERTOKEN_AUTH("bearer_token", String.class),
    APP_COMPRESSED_DATA("app_compressed_data", Boolean.class, "false"),
    METRICS_GROUP_NAME("metrics_name", String.class, "ch-http-pool"),
    HTTP_SAVE_COOKIES("client.http.cookies_enabled", Boolean.class, "false"),
    BINARY_READER_USE_PREALLOCATED_BUFFERS("client_allow_binary_reader_to_reuse_buffers", Boolean.class, "false"),
    TYPE_HINT_MAPPING("type_hint_mapping", Map.class),
    SSL_SOCKET_SNI("ssl_socket_sni", String.class, "");

    private static final Logger LOG;
    private final String key;
    private final Class<?> valueType;
    private final String defaultValue;
    private final Object defaultObjValue;
    public static final String HTTP_HEADER_PREFIX = "http_header_";
    public static final String SERVER_SETTING_PREFIX = "clickhouse_setting_";
    public static final String DEFAULT_KEY = "_default_";

    private ClientConfigProperties(String key, Class<?> valueType) {
        this(key, valueType, null);
    }

    private ClientConfigProperties(String key, Class<?> valueType, String defaultValue) {
        this.key = key;
        this.valueType = valueType;
        this.defaultValue = defaultValue;
        this.defaultObjValue = this.parseValue(defaultValue);
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public <T> T getDefObjVal() {
        return (T)this.defaultObjValue;
    }

    public static String serverSetting(String key) {
        return SERVER_SETTING_PREFIX + key;
    }

    public static String httpHeader(String key) {
        return HTTP_HEADER_PREFIX + key.toUpperCase(Locale.US);
    }

    public static String commaSeparated(Collection<?> values) {
        StringBuilder sb = new StringBuilder();
        for (Object value : values) {
            sb.append(value.toString().replaceAll(",", "\\\\,")).append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static List<String> valuesFromCommaSeparated(String value) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(value.split("(?<!\\\\),")).map(s -> s.replaceAll("\\\\,", ",")).collect(Collectors.toList());
    }

    public Object parseValue(String value) {
        if (value == null) {
            return null;
        }
        if (this.valueType.equals(String.class)) {
            return value;
        }
        if (this.valueType.equals(Boolean.class)) {
            if (value.equals("1")) {
                return true;
            }
            if (value.equals("0")) {
                return false;
            }
            return Boolean.parseBoolean(value);
        }
        if (this.valueType.equals(Integer.class)) {
            return Integer.parseInt(value);
        }
        if (this.valueType.equals(Long.class)) {
            return Long.parseLong(value);
        }
        if (this.valueType.equals(List.class)) {
            return ClientConfigProperties.valuesFromCommaSeparated(value);
        }
        if (this.valueType.isEnum()) {
            ?[] constants;
            for (Object constant : constants = this.valueType.getEnumConstants()) {
                if (!constant.toString().equals(value)) continue;
                return constant;
            }
            throw new IllegalArgumentException("Invalid constant name '" + value + "' for enum " + this.valueType.getName());
        }
        if (this.valueType.equals(TimeZone.class)) {
            return TimeZone.getTimeZone(value);
        }
        if (this.valueType.equals(Map.class)) {
            return ClientConfigProperties.toKeyValuePairs(value);
        }
        return null;
    }

    public <T> T getOrDefault(Map<String, Object> configMap) {
        return (T)configMap.getOrDefault(this.getKey(), this.getDefObjVal());
    }

    public <T> void applyIfSet(Map<String, Object> configMap, Consumer<T> consumer) {
        Object value = configMap.get(this.getKey());
        if (value != null) {
            consumer.accept(value);
        }
    }

    public static Map<String, Object> parseConfigMap(Map<String, String> configMap) {
        HashMap<String, Object> parsedConfig = new HashMap<String, Object>();
        HashMap<String, String> tmpMap = new HashMap<String, String>(configMap);
        for (ClientConfigProperties config : ClientConfigProperties.values()) {
            Object parsedValue;
            String value = (String)tmpMap.remove(config.getKey());
            if (value == null) continue;
            switch (config) {
                case TYPE_HINT_MAPPING: {
                    parsedValue = ClientConfigProperties.translateTypeHintMapping(value);
                    break;
                }
                default: {
                    parsedValue = config.parseValue(value);
                }
            }
            parsedConfig.put(config.getKey(), parsedValue);
        }
        for (String key : new HashSet(tmpMap.keySet())) {
            if (!key.startsWith(HTTP_HEADER_PREFIX) && !key.startsWith(SERVER_SETTING_PREFIX)) continue;
            parsedConfig.put(key, tmpMap.remove(key));
        }
        if (!tmpMap.isEmpty()) {
            LOG.warn("Unknown and unmapped config properties: {}", tmpMap);
        }
        return parsedConfig;
    }

    public static Map<String, String> toKeyValuePairs(String str) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String key = null;
        StringBuilder builder = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i + 1 < len) {
                ch = str.charAt(++i);
                builder.append(ch);
                continue;
            }
            if (Character.isWhitespace(ch)) {
                if (builder.length() <= 0) continue;
                builder.append(ch);
                continue;
            }
            if (ch == '=' && key == null) {
                key = builder.toString().trim();
                builder.setLength(0);
                continue;
            }
            if (ch == ',' && key != null) {
                String value = builder.toString().trim();
                builder.setLength(0);
                if (!key.isEmpty() && !value.isEmpty()) {
                    map.put(key, value);
                }
                key = null;
                continue;
            }
            builder.append(ch);
        }
        if (key != null && builder.length() > 0) {
            String value = builder.toString().trim();
            if (!key.isEmpty() && !value.isEmpty()) {
                map.put(key, value);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static String mapToString(Map<?, ?> map, Function<Object, String> valueConverter) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(entry.getKey()).append("=").append(valueConverter.apply(entry.getValue())).append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Map<ClickHouseDataType, Class<?>> translateTypeHintMapping(String mappingStr) {
        if (mappingStr == null || mappingStr.isEmpty()) {
            return AbstractBinaryFormatReader.NO_TYPE_HINT_MAPPING;
        }
        Map<String, String> mapping = ClientConfigProperties.toKeyValuePairs(mappingStr);
        HashMap hintMapping = new HashMap();
        try {
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                hintMapping.put(ClickHouseDataType.of((String)entry.getKey()), Class.forName(entry.getValue()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new ClientMisconfigurationException("Failed to translate type-hint mapping", e);
        }
        return hintMapping;
    }

    static {
        LOG = LoggerFactory.getLogger(ClientConfigProperties.class);
    }
}

