/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.audio.rooms.model;

import com.coze.openapi.client.audio.rooms.model.AudioCodec;
import com.coze.openapi.client.audio.rooms.model.RoomAudioConfig;
import com.coze.openapi.client.audio.rooms.model.TranslateConfig;
import com.fasterxml.jackson.annotation.JsonProperty;

public class RoomConfig {
    @JsonProperty(value="audio_config")
    private RoomAudioConfig audioConfig;
    @JsonProperty(value="room_mode")
    private String roomMode = "";
    @JsonProperty(value="translate_config")
    private TranslateConfig translateConfig;

    public static RoomConfig of(AudioCodec codec) {
        return RoomConfig.builder().audioConfig(RoomAudioConfig.builder().codec(codec).build()).build();
    }

    public static RoomConfigBuilder builder() {
        return new RoomConfigBuilder();
    }

    public RoomAudioConfig getAudioConfig() {
        return this.audioConfig;
    }

    public String getRoomMode() {
        return this.roomMode;
    }

    public TranslateConfig getTranslateConfig() {
        return this.translateConfig;
    }

    @JsonProperty(value="audio_config")
    public void setAudioConfig(RoomAudioConfig audioConfig) {
        this.audioConfig = audioConfig;
    }

    @JsonProperty(value="room_mode")
    public void setRoomMode(String roomMode) {
        this.roomMode = roomMode;
    }

    @JsonProperty(value="translate_config")
    public void setTranslateConfig(TranslateConfig translateConfig) {
        this.translateConfig = translateConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoomConfig)) {
            return false;
        }
        RoomConfig other = (RoomConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RoomAudioConfig this$audioConfig = this.getAudioConfig();
        RoomAudioConfig other$audioConfig = other.getAudioConfig();
        if (this$audioConfig == null ? other$audioConfig != null : !((Object)this$audioConfig).equals(other$audioConfig)) {
            return false;
        }
        String this$roomMode = this.getRoomMode();
        String other$roomMode = other.getRoomMode();
        if (this$roomMode == null ? other$roomMode != null : !this$roomMode.equals(other$roomMode)) {
            return false;
        }
        TranslateConfig this$translateConfig = this.getTranslateConfig();
        TranslateConfig other$translateConfig = other.getTranslateConfig();
        return !(this$translateConfig == null ? other$translateConfig != null : !((Object)this$translateConfig).equals(other$translateConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoomConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RoomAudioConfig $audioConfig = this.getAudioConfig();
        result = result * 59 + ($audioConfig == null ? 43 : ((Object)$audioConfig).hashCode());
        String $roomMode = this.getRoomMode();
        result = result * 59 + ($roomMode == null ? 43 : $roomMode.hashCode());
        TranslateConfig $translateConfig = this.getTranslateConfig();
        result = result * 59 + ($translateConfig == null ? 43 : ((Object)$translateConfig).hashCode());
        return result;
    }

    public String toString() {
        return "RoomConfig(audioConfig=" + this.getAudioConfig() + ", roomMode=" + this.getRoomMode() + ", translateConfig=" + this.getTranslateConfig() + ")";
    }

    public RoomConfig() {
    }

    public RoomConfig(RoomAudioConfig audioConfig, String roomMode, TranslateConfig translateConfig) {
        this.audioConfig = audioConfig;
        this.roomMode = roomMode;
        this.translateConfig = translateConfig;
    }

    public static class RoomConfigBuilder {
        private RoomAudioConfig audioConfig;
        private String roomMode;
        private TranslateConfig translateConfig;

        RoomConfigBuilder() {
        }

        @JsonProperty(value="audio_config")
        public RoomConfigBuilder audioConfig(RoomAudioConfig audioConfig) {
            this.audioConfig = audioConfig;
            return this;
        }

        @JsonProperty(value="room_mode")
        public RoomConfigBuilder roomMode(String roomMode) {
            this.roomMode = roomMode;
            return this;
        }

        @JsonProperty(value="translate_config")
        public RoomConfigBuilder translateConfig(TranslateConfig translateConfig) {
            this.translateConfig = translateConfig;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this.audioConfig, this.roomMode, this.translateConfig);
        }

        public String toString() {
            return "RoomConfig.RoomConfigBuilder(audioConfig=" + this.audioConfig + ", roomMode=" + this.roomMode + ", translateConfig=" + this.translateConfig + ")";
        }
    }
}

