/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk;

import io.stargate.sdk.Service;
import io.stargate.sdk.ServiceDatacenter;
import io.stargate.sdk.api.TokenProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ServiceDeployment<SERVICE extends Service> {
    private Map<String, ServiceDatacenter<SERVICE>> datacenters = new HashMap<String, ServiceDatacenter<SERVICE>>();
    private String localDc;

    public ServiceDeployment() {
    }

    @SafeVarargs
    public ServiceDeployment(ServiceDatacenter<SERVICE> ... datacenters) {
        if (datacenters != null) {
            this.datacenters = Arrays.stream(datacenters).collect(Collectors.toMap(ServiceDatacenter::getId, Function.identity()));
        }
        if (this.datacenters.size() == 1) {
            this.localDc = this.datacenters.keySet().iterator().next();
        }
    }

    public ServiceDeployment<SERVICE> setDatacenters(Map<String, ServiceDatacenter<SERVICE>> datacenters) {
        this.datacenters = datacenters;
        return this;
    }

    public ServiceDeployment<SERVICE> setLocalDc(String localDc) {
        this.localDc = localDc;
        return this;
    }

    public ServiceDeployment<SERVICE> addDatacenter(String dcName) {
        if (!this.datacenters.containsKey(dcName)) {
            this.datacenters.put(dcName, new ServiceDatacenter(dcName));
        }
        if (this.localDc == null) {
            this.setLocalDc(dcName);
        }
        return this;
    }

    public ServiceDeployment<SERVICE> addDatacenter(ServiceDatacenter<SERVICE> dc) {
        this.datacenters.put(dc.getId(), dc);
        return this;
    }

    @SafeVarargs
    public final ServiceDeployment<SERVICE> addDatacenterServices(String dcName, SERVICE ... services) {
        this.addDatacenter(dcName);
        Arrays.stream(services).forEach(s -> this.datacenters.get(dcName).addService((Service)s));
        return this;
    }

    public final ServiceDeployment<SERVICE> addDatacenterTokenProvider(String dcName, TokenProvider apiTokenProvider) {
        this.addDatacenter(dcName);
        this.datacenters.get(dcName).setTokenProvider(apiTokenProvider);
        return this;
    }

    public Map<String, ServiceDatacenter<SERVICE>> getDatacenters() {
        return this.datacenters;
    }

    public String getLocalDc() {
        return this.localDc;
    }
}

