/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.loadbalancer;

import java.util.Date;
import java.util.UUID;

public class LoadBalancedResource<RSC>
implements Comparable<LoadBalancedResource<RSC>> {
    private String id;
    private double defaultWeight;
    private double currentWeight;
    private double nbUse;
    private int priority;
    private boolean available;
    private String unavailabilityCause;
    private Throwable unavailabilityError;
    private Date unavailabilityTriggerDate;
    private RSC resource;

    public LoadBalancedResource(RSC resource) {
        this(UUID.randomUUID().toString(), 0.0, resource);
    }

    public LoadBalancedResource(String id, RSC resource) {
        this(id, 0.0, resource);
    }

    public LoadBalancedResource(String id, double defaultWeight, RSC resource) {
        this.id = id;
        this.defaultWeight = defaultWeight;
        this.resource = resource;
    }

    @Override
    public final int compareTo(LoadBalancedResource<RSC> o) {
        int exitValue = o.isAvailable() == this.available ? o.getPriority() - this.priority : (o.isAvailable() ? -1 : 1);
        return exitValue;
    }

    public final String toString() {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(this.id);
        strBuild.append("(" + Double.valueOf(this.defaultWeight).intValue() + "%)");
        if (this.isAvailable()) {
            strBuild.append(" current weight " + Double.valueOf(this.currentWeight).intValue() + "% " + this.resource.toString());
        } else {
            strBuild.append(" ---");
        }
        return strBuild.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getDefaultWeight() {
        return this.defaultWeight;
    }

    public void setDefaultWeight(double defaultWeight) {
        this.defaultWeight = defaultWeight;
    }

    public double getCurrentWeight() {
        return this.currentWeight;
    }

    public void setCurrentWeight(double currentWeight) {
        this.currentWeight = currentWeight;
    }

    public double getNbUse() {
        return this.nbUse;
    }

    public void setNbUse(double nbUse) {
        this.nbUse = nbUse;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public String getUnavailabilityCause() {
        return this.unavailabilityCause;
    }

    public void setUnavailabilityCause(String unavailabilityCause) {
        this.unavailabilityCause = unavailabilityCause;
    }

    public Throwable getUnavailabilityError() {
        return this.unavailabilityError;
    }

    public void setUnavailabilityError(Throwable unavailabilityError) {
        this.unavailabilityError = unavailabilityError;
    }

    public Date getUnavailabilityTriggerDate() {
        return this.unavailabilityTriggerDate;
    }

    public void setUnavailabilityTriggerDate(Date unavailabilityTriggerDate) {
        this.unavailabilityTriggerDate = unavailabilityTriggerDate;
    }

    public RSC getResource() {
        return this.resource;
    }

    public void setResource(RSC rsc) {
        this.resource = rsc;
    }
}

