/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.stargate.sdk.serialization.CustomEJsonCalendarDeserializer;
import io.stargate.sdk.serialization.CustomEJsonCalendarSerializer;
import io.stargate.sdk.serialization.CustomEJsonDateDeserializer;
import io.stargate.sdk.serialization.CustomEJsonDateSerializer;
import io.stargate.sdk.serialization.CustomEJsonInstantDeserializer;
import io.stargate.sdk.serialization.CustomEJsonInstantSerializer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class JsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule((Module)new JavaTimeModule()).setDateFormat((DateFormat)new SimpleDateFormat("dd/MM/yyyy")).setSerializationInclusion(JsonInclude.Include.NON_NULL).setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
    private static ObjectMapper dataApiObjectMapper;

    public static synchronized ObjectMapper getDataApiObjectMapper() {
        if (dataApiObjectMapper == null) {
            dataApiObjectMapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule((Module)new JavaTimeModule()).setDateFormat((DateFormat)new SimpleDateFormat("dd/MM/yyyy")).setSerializationInclusion(JsonInclude.Include.NON_NULL).setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
            SimpleModule module = new SimpleModule();
            module.addSerializer(Date.class, (JsonSerializer)new CustomEJsonDateSerializer());
            module.addSerializer(Calendar.class, (JsonSerializer)new CustomEJsonCalendarSerializer());
            module.addSerializer(Instant.class, (JsonSerializer)new CustomEJsonInstantSerializer());
            module.addDeserializer(Date.class, (JsonDeserializer)new CustomEJsonDateDeserializer());
            module.addDeserializer(Calendar.class, (JsonDeserializer)new CustomEJsonCalendarDeserializer());
            module.addDeserializer(Instant.class, (JsonDeserializer)new CustomEJsonInstantDeserializer());
            dataApiObjectMapper.registerModule((Module)module);
        }
        return dataApiObjectMapper;
    }

    private JsonUtils() {
    }

    public static String escapeJson(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        int len = value.length();
        block10: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\"': {
                    output.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    output.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    output.append("\\b");
                    continue block10;
                }
                case '\f': {
                    output.append("\\f");
                    continue block10;
                }
                case '\n': {
                    output.append("\\n");
                    continue block10;
                }
                case '\r': {
                    output.append("\\r");
                    continue block10;
                }
                case '\t': {
                    output.append("\\t");
                    continue block10;
                }
                case '/': {
                    output.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        output.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            output.append('0');
                        }
                        output.append(ss.toUpperCase());
                        continue block10;
                    }
                    output.append(ch);
                }
            }
        }
        return output.toString();
    }

    public static String valueAsJson(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + JsonUtils.escapeJson(value.toString()) + "\"";
        }
        return value.toString();
    }

    public static <T> String collectionAsJson(Collection<T> pCollec) {
        if (pCollec == null) {
            return "null";
        }
        if (pCollec.isEmpty()) {
            return "[]";
        }
        StringBuilder json = new StringBuilder("[");
        boolean first = true;
        for (T element : pCollec) {
            json.append(first ? "" : ",");
            json.append(JsonUtils.valueAsJson(element));
            first = false;
        }
        json.append("]");
        return json.toString();
    }

    public static <K, V> String mapAsJson(Map<K, V> pMap) {
        if (pMap == null) {
            return "null";
        }
        if (pMap.isEmpty()) {
            return "{}";
        }
        StringBuilder json = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<K, V> mapEntry : pMap.entrySet()) {
            json.append(first ? "" : ",");
            json.append(JsonUtils.valueAsJson(mapEntry.getKey()) + ":");
            json.append(JsonUtils.valueAsJson(mapEntry.getValue()));
            first = false;
        }
        json.append("}");
        return json.toString();
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static String marshall(Object o) {
        Objects.requireNonNull(o);
        try {
            if (o instanceof String) {
                return (String)o;
            }
            return JsonUtils.getObjectMapper().writeValueAsString(o);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot marshall object " + String.valueOf(o), e);
        }
    }

    public static String marshallForDataApi(Object o) {
        Objects.requireNonNull(o);
        try {
            if (o instanceof String) {
                return (String)o;
            }
            return JsonUtils.getDataApiObjectMapper().writeValueAsString(o);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot marshall object " + String.valueOf(o), e);
        }
    }

    public static <T> T convertValue(Object bean, Class<T> clazz) {
        return (T)JsonUtils.getObjectMapper().convertValue(bean, clazz);
    }

    public static <T> T convertValueForDataApi(Object bean, Class<T> clazz) {
        return (T)JsonUtils.getDataApiObjectMapper().convertValue(bean, clazz);
    }

    public static <T> T unmarshallType(String body, TypeReference<T> ref) {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(body, ref);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("Cannot unmarshall object " + body, e);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot unmarshall object " + body, e);
        }
    }

    public static <T> T unmarshallTypeForDataApi(String body, TypeReference<T> ref) {
        try {
            return (T)JsonUtils.getDataApiObjectMapper().readValue(body, ref);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("Cannot unmarshall object " + body, e);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot unmarshall object " + body, e);
        }
    }

    public static <T> T unmarshallBean(String body, Class<T> ref) {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(body, ref);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("Cannot unmarshall object " + body, e);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot unmarshall object " + body, e);
        }
    }

    public static <T> T unmarshallBeanForDataApi(String body, Class<T> ref) {
        try {
            return (T)JsonUtils.getDataApiObjectMapper().readValue(body, ref);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("Cannot unmarshall object " + body, e);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot unmarshall object " + body, e);
        }
    }
}

