/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import shade.com.alibaba.fastjson2.JSONArray;
import shade.com.alibaba.fastjson2.JSONException;
import shade.com.alibaba.fastjson2.JSONFactory;
import shade.com.alibaba.fastjson2.JSONObject;
import shade.com.alibaba.fastjson2.JSONReader;
import shade.com.alibaba.fastjson2.JSONWriter;
import shade.com.alibaba.fastjson2.TypeReference;
import shade.com.alibaba.fastjson2.filter.AfterFilter;
import shade.com.alibaba.fastjson2.filter.BeforeFilter;
import shade.com.alibaba.fastjson2.filter.ContextNameFilter;
import shade.com.alibaba.fastjson2.filter.ContextValueFilter;
import shade.com.alibaba.fastjson2.filter.Filter;
import shade.com.alibaba.fastjson2.filter.LabelFilter;
import shade.com.alibaba.fastjson2.filter.NameFilter;
import shade.com.alibaba.fastjson2.filter.PropertyFilter;
import shade.com.alibaba.fastjson2.filter.PropertyPreFilter;
import shade.com.alibaba.fastjson2.filter.ValueFilter;
import shade.com.alibaba.fastjson2.modules.ObjectReaderModule;
import shade.com.alibaba.fastjson2.modules.ObjectWriterModule;
import shade.com.alibaba.fastjson2.reader.FieldReader;
import shade.com.alibaba.fastjson2.reader.ObjectReader;
import shade.com.alibaba.fastjson2.reader.ObjectReaderBean;
import shade.com.alibaba.fastjson2.reader.ObjectReaderNoneDefaultConstructor;
import shade.com.alibaba.fastjson2.reader.ObjectReaderProvider;
import shade.com.alibaba.fastjson2.util.DateUtils;
import shade.com.alibaba.fastjson2.util.MapMultiValueType;
import shade.com.alibaba.fastjson2.util.MultiType;
import shade.com.alibaba.fastjson2.util.TypeUtils;
import shade.com.alibaba.fastjson2.writer.FieldWriter;
import shade.com.alibaba.fastjson2.writer.ObjectWriter;
import shade.com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import shade.com.alibaba.fastjson2.writer.ObjectWriterProvider;

public interface JSON {
    public static final String VERSION = "2.0.46";

    public static Object parse(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        try (JSONReader reader = JSONReader.of(text, context);){
            Object object;
            char ch = reader.current();
            if (context.objectSupplier == null && (context.features & JSONReader.Feature.UseNativeObject.mask) == 0L && (ch == '{' || ch == '[')) {
                if (ch == '{') {
                    JSONObject jsonObject = new JSONObject();
                    reader.read(jsonObject, 0L);
                    object = jsonObject;
                } else {
                    JSONArray array = new JSONArray();
                    reader.read(array);
                    object = array;
                }
                if (reader.resolveTasks != null) {
                    reader.handleResolveTasks(object);
                }
            } else {
                ObjectReader objectReader = provider.getObjectReader((Type)((Object)Object.class), false);
                object = objectReader.readObject(reader, null, null, 0L);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(String text, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, features);
        ObjectReader objectReader = provider.getObjectReader((Type)((Object)Object.class), false);
        try (JSONReader reader = JSONReader.of(text, context);){
            context.config(features);
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(String text, int offset, int length, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, features);
        ObjectReader objectReader = provider.getObjectReader((Type)((Object)Object.class), false);
        try (JSONReader reader = JSONReader.of(text, offset, length, context);){
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(String text, JSONReader.Context context) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReader objectReader = context.provider.getObjectReader((Type)((Object)Object.class), false);
        try (JSONReader reader = JSONReader.of(text, context);){
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(byte[] bytes, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, features);
        ObjectReader objectReader = provider.getObjectReader((Type)((Object)Object.class), false);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(char[] chars, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, features);
        ObjectReader objectReader = provider.getObjectReader((Type)((Object)Object.class), false);
        try (JSONReader reader = JSONReader.of(chars, context);){
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static JSONObject parseObject(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(text, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(text, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, int offset, int length, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(text, offset, length, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, int offset, int length, JSONReader.Context context) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text, offset, length, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, JSONReader.Context context) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(Reader input, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(input, context);){
            if (reader.isEnd()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(InputStream input, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8, context);){
            if (reader.isEnd()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(bytes, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(char[] chars) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(chars, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(InputStream in, Charset charset) {
        if (in == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(in, charset, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(URL url) {
        JSONObject jSONObject;
        block9: {
            if (url == null) {
                return null;
            }
            InputStream is = url.openStream();
            try {
                jSONObject = JSON.parseObject(is, StandardCharsets.UTF_8);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JSONException("JSON#parseObject cannot parse '" + url + "'", e);
                }
            }
            is.close();
        }
        return jSONObject;
    }

    public static JSONObject parseObject(byte[] bytes, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes, int offset, int length, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(bytes, offset, length, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(char[] chars, int offset, int length, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(chars, offset, length, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes, int offset, int length, Charset charset, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        ObjectReader objectReader = provider.getObjectReader(clazz, (JSONFactory.defaultReaderFeatures & JSONReader.Feature.FieldBased.mask) != 0L);
        try (JSONReader reader = JSONReader.of(text, context);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, Filter filter, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(filter, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
        try (JSONReader reader = JSONReader.of(text, context);){
            if (reader.nextIfNull()) {
                T t = null;
                return t;
            }
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, String format, Filter[] filters, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider(), null, filters, features);
        context.setDateFormat(format);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(type, fieldBased);
        try (JSONReader reader = JSONReader.of(text, context);){
            if (reader.nextIfNull()) {
                T t = null;
                return t;
            }
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        ObjectReader objectReader = provider.getObjectReader(type, (JSONFactory.defaultReaderFeatures & JSONReader.Feature.FieldBased.mask) != 0L);
        try (JSONReader reader = JSONReader.of(text, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T extends Map<String, Object>> T parseObject(String text, MapMultiValueType<T> type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(text, context);){
            Map object = (Map)objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Map map = object;
            return (T)map;
        }
    }

    public static <T> T parseObject(String text, Type ... types) {
        return JSON.parseObject(text, (Type)new MultiType(types));
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        Type type = typeReference.getType();
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(type, fieldBased);
        try (JSONReader reader = JSONReader.of(text, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference, Filter filter, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(filter, features);
        Type type = typeReference.getType();
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(type, fieldBased);
        try (JSONReader reader = JSONReader.of(text, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
        try (JSONReader reader = JSONReader.of(text, context);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, int offset, int length, Class<T> clazz, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
        try (JSONReader reader = JSONReader.of(text, offset, length, context);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, JSONReader.Context context) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
        try (JSONReader reader = JSONReader.of(text, context);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, String format, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
        try (JSONReader reader = JSONReader.of(text, context);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(text, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, Filter filter, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(filter, features);
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(text, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, String format, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        try (JSONReader reader = JSONReader.of(text, context);){
            ObjectReader objectReader = context.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(char[] chars, int offset, int length, Type type, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(chars, offset, length, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(char[] chars, Class<T> clazz) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReader objectReader = context.getObjectReader(clazz);
        try (JSONReader reader = JSONReader.of(chars, context);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Type type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(bytes, offset, length, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        ObjectReader objectReader = provider.getObjectReader(clazz, (JSONFactory.defaultReaderFeatures & JSONReader.Feature.FieldBased.mask) != 0L);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz, Filter filter, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(filter, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz, JSONReader.Context context) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, String format, Filter[] filters, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider(), null, filters, features);
        context.setDateFormat(format);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(type, fieldBased);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        ObjectReader objectReader = context.getObjectReader(clazz);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(char[] chars, Class<T> objectClass, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        ObjectReader objectReader = context.getObjectReader(objectClass);
        try (JSONReader reader = JSONReader.of(chars, context);){
            Object object = objectReader.readObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(char[] chars, Type type, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(chars, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, Filter filter, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(filter, features);
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, String format, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(ByteBuffer buffer, Class<T> objectClass) {
        if (buffer == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReader objectReader = context.getObjectReader(objectClass);
        try (JSONReader reader = JSONReader.of(buffer, null, context);){
            Object object = objectReader.readObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(Reader input, Type type, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(input, context);){
            if (reader.isEnd()) {
                T t = null;
                return t;
            }
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(InputStream input, Type type, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        context.config(features);
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8, context);){
            if (reader.isEnd()) {
                T t = null;
                return t;
            }
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Type type, JSONReader.Feature ... features) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            T t = JSON.parseObject(is, type, features);
            return t;
        }
        catch (IOException e) {
            throw new JSONException("parseObject error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Class<T> objectClass, JSONReader.Feature ... features) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            T t = JSON.parseObject(is, objectClass, features);
            return t;
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse '" + url + "' to '" + objectClass + "'", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Function<JSONObject, T> function, JSONReader.Feature ... features) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            JSONObject object = JSON.parseObject(is, features);
            if (object == null) {
                T t = null;
                return t;
            }
            JSONObject jSONObject = function.apply(object);
            return (T)jSONObject;
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse '" + url + "'", e);
        }
    }

    public static <T> T parseObject(InputStream input, Type type, String format, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(InputStream input, Charset charset, Type type, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(input, charset, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Charset charset, Type type) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Charset charset, Class<T> type) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Charset charset, Class<T> type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        ObjectReader objectReader = context.getObjectReader(type);
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> void parseObject(InputStream input, Type type, Consumer<T> consumer, JSONReader.Feature ... features) {
        JSON.parseObject(input, StandardCharsets.UTF_8, '\n', type, consumer, features);
    }

    public static <T> void parseObject(InputStream input, Charset charset, char delimiter, Type type, Consumer<T> consumer, JSONReader.Feature ... features) {
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(cacheItem, null);
        int bufferSize = 524288;
        if (bytes == null) {
            bytes = new byte[bufferSize];
        }
        int offset = 0;
        int start = 0;
        ObjectReader objectReader = null;
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try {
            int n;
            while ((n = input.read(bytes, offset, bytes.length - offset)) != -1) {
                int k = offset;
                offset += n;
                boolean dispose = false;
                while (k < offset) {
                    if (bytes[k] == delimiter) {
                        int end = k;
                        JSONReader jsonReader = JSONReader.of(bytes, start, end - start, charset, context);
                        if (objectReader == null) {
                            objectReader = context.getObjectReader(type);
                        }
                        Object object = objectReader.readObject(jsonReader, type, null, 0L);
                        if (jsonReader.resolveTasks != null) {
                            jsonReader.handleResolveTasks(object);
                        }
                        if (jsonReader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                            throw new JSONException(jsonReader.info("input not end"));
                        }
                        consumer.accept(object);
                        start = end + 1;
                        dispose = true;
                    }
                    ++k;
                }
                if (offset != bytes.length) continue;
                if (dispose) {
                    int len = bytes.length - start;
                    System.arraycopy(bytes, start, bytes, 0, len);
                    start = 0;
                    offset = len;
                    continue;
                }
                bytes = Arrays.copyOf(bytes, bytes.length + bufferSize);
            }
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse the 'InputStream' to '" + type + "'", e);
        }
        finally {
            JSONFactory.BYTES_UPDATER.lazySet(cacheItem, bytes);
        }
    }

    public static <T> void parseObject(Reader input, char delimiter, Type type, Consumer<T> consumer) {
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        char[] chars = JSONFactory.CHARS_UPDATER.getAndSet(cacheItem, null);
        if (chars == null) {
            chars = new char[8192];
        }
        int offset = 0;
        int start = 0;
        ObjectReader objectReader = null;
        JSONReader.Context context = JSONFactory.createReadContext();
        try {
            int n;
            while ((n = input.read(chars, offset, chars.length - offset)) != -1) {
                int k = offset;
                offset += n;
                boolean dispose = false;
                while (k < offset) {
                    if (chars[k] == delimiter) {
                        int end = k;
                        JSONReader jsonReader = JSONReader.of(chars, start, end - start, context);
                        if (objectReader == null) {
                            objectReader = context.getObjectReader(type);
                        }
                        consumer.accept(objectReader.readObject(jsonReader, type, null, 0L));
                        start = end + 1;
                        dispose = true;
                    }
                    ++k;
                }
                if (offset != chars.length) continue;
                if (dispose) {
                    int len = chars.length - start;
                    System.arraycopy(chars, start, chars, 0, len);
                    start = 0;
                    offset = len;
                    continue;
                }
                chars = Arrays.copyOf(chars, chars.length + 8192);
            }
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse the 'Reader' to '" + type + "'", e);
        }
        finally {
            JSONFactory.CHARS_UPDATER.lazySet(cacheItem, chars);
        }
    }

    public static JSONArray parseArray(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(text, context);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(bytes, context);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(byte[] bytes, int offset, int length, Charset charset) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset, context);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(char[] chars) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(chars, context);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(String text, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(text, context);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(URL url, JSONReader.Feature ... features) {
        JSONArray jSONArray;
        block9: {
            if (url == null) {
                return null;
            }
            InputStream is = url.openStream();
            try {
                jSONArray = JSON.parseArray(is, features);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JSONException("JSON#parseArray cannot parse '" + url + "' to '" + JSONArray.class + "'", e);
                }
            }
            is.close();
        }
        return jSONArray;
    }

    public static JSONArray parseArray(InputStream in, JSONReader.Feature ... features) {
        if (in == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(in, StandardCharsets.UTF_8, context);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static <T> List<T> parseArray(String text, Type type, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(text, context);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Type type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(text, context);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(text, context);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Type ... types) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(text, context);){
            List list = reader.readList(types);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> type, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(text, context);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(char[] chars, Class<T> type, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(chars, context);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Type[] types, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(text, context);){
            if (reader.nextIfNull()) {
                List<T> list = null;
                return list;
            }
            reader.startArray();
            ArrayList array = new ArrayList(types.length);
            for (int i = 0; i < types.length; ++i) {
                array.add(reader.read(types[i]));
            }
            reader.endArray();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            ArrayList arrayList = array;
            return arrayList;
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, Type type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, Class<T> type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(bytes, context);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, int offset, int length, Charset charset, Class<T> type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset, context);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static String toJSONString(Object object) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider);
        JSONWriter writer = JSONWriter.of(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                if (valueClass == JSONObject.class && context.features == 0L) {
                    writer.write((JSONObject)object);
                } else {
                    ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, (JSONFactory.defaultWriterFeatures & JSONWriter.Feature.FieldBased.mask) != 0L);
                    objectWriter.write(writer, object, null, null, 0L);
                }
            }
            String string = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new JSONException("JSON#toJSONString cannot serialize '" + object + "'", e);
            }
        }
    }

    public static String toJSONString(Object object, JSONWriter.Context context) {
        if (context == null) {
            context = JSONFactory.createWriteContext();
        }
        JSONWriter writer = JSONWriter.of(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new JSONException("JSON#toJSONString cannot serialize '" + object + "'", e);
            }
        }
    }

    public static String toJSONString(Object object, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        try (JSONWriter writer = JSONWriter.of(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                ObjectWriter objectWriter = context.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, Filter filter, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        try (JSONWriter writer = JSONWriter.of(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (filter != null) {
                    writer.context.configFilter(filter);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, Filter[] filters, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        if (filters != null && filters.length != 0) {
            context.configFilter(filters);
        }
        try (JSONWriter writer = JSONWriter.of(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, String format, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        try (JSONWriter writer = JSONWriter.of(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        if (filters != null && filters.length != 0) {
            context.configFilter(filters);
        }
        try (JSONWriter writer = JSONWriter.of(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static byte[] toJSONBytes(Object object) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider);
        try (JSONWriter writer = JSONWriter.ofUTF8(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                if (valueClass == JSONObject.class && writer.context.features == 0L) {
                    writer.write((JSONObject)object);
                } else {
                    ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, (JSONFactory.defaultWriterFeatures & JSONWriter.Feature.FieldBased.mask) != 0L);
                    objectWriter.write(writer, object, null, null, 0L);
                }
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, String format, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        try (JSONWriter writer = JSONWriter.ofUTF8(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, Filter ... filters) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider);
        if (filters != null && filters.length != 0) {
            context.configFilter(filters);
        }
        try (JSONWriter writer = JSONWriter.ofUTF8(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        try (JSONWriter writer = JSONWriter.ofUTF8(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, Filter[] filters, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        if (filters != null && filters.length != 0) {
            context.configFilter(filters);
        }
        try (JSONWriter writer = JSONWriter.ofUTF8(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        if (filters != null && filters.length != 0) {
            context.configFilter(filters);
        }
        try (JSONWriter writer = JSONWriter.ofUTF8(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static int writeTo(OutputStream out, Object object) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider);
        JSONWriter writer = JSONWriter.ofUTF8(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
    }

    public static int writeTo(OutputStream out, Object object, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        JSONWriter writer = JSONWriter.ofUTF8(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
    }

    public static int writeTo(OutputStream out, Object object, Filter[] filters, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        if (filters != null && filters.length != 0) {
            context.configFilter(filters);
        }
        JSONWriter writer = JSONWriter.ofUTF8(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException("JSON#writeTo cannot serialize '" + object + "' to 'OutputStream'", e);
            }
        }
    }

    public static int writeTo(OutputStream out, Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        if (filters != null && filters.length != 0) {
            context.configFilter(filters);
        }
        JSONWriter writer = JSONWriter.ofUTF8(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException("JSON#writeTo cannot serialize '" + object + "' to 'OutputStream'", e);
            }
        }
    }

    public static boolean isValid(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(text);
        try {
            boolean bl;
            jsonReader.skipValue();
            boolean bl2 = bl = jsonReader.isEnd() && !jsonReader.comma;
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    public static boolean isValid(String text, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(text, JSONFactory.createReadContext(features));
        try {
            boolean bl;
            jsonReader.skipValue();
            boolean bl2 = bl = jsonReader.isEnd() && !jsonReader.comma;
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    public static boolean isValid(char[] chars) {
        if (chars == null || chars.length == 0) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(chars);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidObject(String text) {
        if (text == null) return false;
        if (text.isEmpty()) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(text);){
            if (!jsonReader.isObject()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidObject(byte[] bytes) {
        if (bytes == null) return false;
        if (bytes.length == 0) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(bytes);){
            if (!jsonReader.isObject()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidArray(String text) {
        if (text == null) return false;
        if (text.isEmpty()) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(text);){
            if (!jsonReader.isArray()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    public static boolean isValid(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(bytes);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    public static boolean isValid(byte[] bytes, Charset charset) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        return JSON.isValid(bytes, 0, bytes.length, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidArray(byte[] bytes) {
        if (bytes == null) return false;
        if (bytes.length == 0) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(bytes);){
            if (!jsonReader.isArray()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    public static boolean isValid(byte[] bytes, int offset, int length, Charset charset) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(bytes, offset, length, charset);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    public static Object toJSON(Object object) {
        return JSON.toJSON(object, null);
    }

    public static Object toJSON(Object object, JSONWriter.Feature ... features) {
        String str;
        Class<?> valueClass;
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject || object instanceof JSONArray) {
            return object;
        }
        JSONWriter.Context writeContext = features == null ? JSONFactory.createWriteContext() : JSONFactory.createWriteContext(features);
        ObjectWriter<?> objectWriter = writeContext.getObjectWriter(valueClass = object.getClass(), valueClass);
        if (objectWriter instanceof ObjectWriterAdapter && !writeContext.isEnabled(JSONWriter.Feature.ReferenceDetection)) {
            ObjectWriterAdapter objectWriterAdapter = (ObjectWriterAdapter)objectWriter;
            return objectWriterAdapter.toJSONObject(object, writeContext.features);
        }
        try (JSONWriter writer = JSONWriter.of(writeContext);){
            objectWriter.write(writer, object, null, null, writeContext.features);
            str = writer.toString();
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new JSONException("toJSONString error", ex);
        }
        return JSON.parse(str);
    }

    public static <T> T to(Class<T> clazz, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).to(clazz, new JSONReader.Feature[0]);
        }
        return TypeUtils.cast(object, clazz, JSONFactory.getDefaultObjectReaderProvider());
    }

    public static <T> T toJavaObject(Object object, Class<T> clazz) {
        return JSON.to(clazz, object);
    }

    public static void mixIn(Class<?> target, Class<?> mixinSource) {
        JSONFactory.defaultObjectWriterProvider.mixIn(target, mixinSource);
        JSONFactory.getDefaultObjectReaderProvider().mixIn(target, mixinSource);
    }

    public static ObjectReader<?> register(Type type, ObjectReader<?> objectReader) {
        return JSONFactory.getDefaultObjectReaderProvider().register(type, objectReader);
    }

    public static ObjectReader<?> register(Type type, ObjectReader<?> objectReader, boolean fieldBased) {
        return JSONFactory.getDefaultObjectReaderProvider().register(type, objectReader, fieldBased);
    }

    public static ObjectReader<?> registerIfAbsent(Type type, ObjectReader<?> objectReader) {
        return JSONFactory.getDefaultObjectReaderProvider().registerIfAbsent(type, objectReader);
    }

    public static ObjectReader<?> registerIfAbsent(Type type, ObjectReader<?> objectReader, boolean fieldBased) {
        return JSONFactory.getDefaultObjectReaderProvider().registerIfAbsent(type, objectReader, fieldBased);
    }

    public static boolean register(ObjectReaderModule objectReaderModule) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        return provider.register(objectReaderModule);
    }

    public static void registerSeeAlsoSubType(Class subTypeClass) {
        JSON.registerSeeAlsoSubType(subTypeClass, null);
    }

    public static void registerSeeAlsoSubType(Class subTypeClass, String subTypeClassName) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        provider.registerSeeAlsoSubType(subTypeClass, subTypeClassName);
    }

    public static boolean register(ObjectWriterModule objectWriterModule) {
        return JSONFactory.getDefaultObjectWriterProvider().register(objectWriterModule);
    }

    public static ObjectWriter<?> register(Type type, ObjectWriter<?> objectWriter) {
        return JSONFactory.getDefaultObjectWriterProvider().register(type, objectWriter);
    }

    public static ObjectWriter<?> register(Type type, ObjectWriter<?> objectWriter, boolean fieldBased) {
        return JSONFactory.getDefaultObjectWriterProvider().register(type, objectWriter, fieldBased);
    }

    public static ObjectWriter<?> registerIfAbsent(Type type, ObjectWriter<?> objectWriter) {
        return JSONFactory.getDefaultObjectWriterProvider().registerIfAbsent(type, objectWriter);
    }

    public static ObjectWriter<?> registerIfAbsent(Type type, ObjectWriter<?> objectWriter, boolean fieldBased) {
        return JSONFactory.getDefaultObjectWriterProvider().registerIfAbsent(type, objectWriter, fieldBased);
    }

    public static void register(Class type, Filter filter) {
        boolean writerFilter;
        boolean bl = writerFilter = filter instanceof AfterFilter || filter instanceof BeforeFilter || filter instanceof ContextNameFilter || filter instanceof ContextValueFilter || filter instanceof LabelFilter || filter instanceof NameFilter || filter instanceof PropertyFilter || filter instanceof PropertyPreFilter || filter instanceof ValueFilter;
        if (writerFilter) {
            ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(type);
            objectWriter.setFilter(filter);
        }
    }

    public static void config(JSONReader.Feature ... features) {
        for (int i = 0; i < features.length; ++i) {
            JSONReader.Feature feature = features[i];
            if (feature == JSONReader.Feature.SupportAutoType) {
                throw new JSONException("not support config global autotype support");
            }
            JSONFactory.defaultReaderFeatures |= feature.mask;
        }
    }

    public static void config(JSONReader.Feature feature, boolean state) {
        if (feature == JSONReader.Feature.SupportAutoType && state) {
            throw new JSONException("not support config global autotype support");
        }
        JSONFactory.defaultReaderFeatures = state ? (JSONFactory.defaultReaderFeatures |= feature.mask) : (JSONFactory.defaultReaderFeatures &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean isEnabled(JSONReader.Feature feature) {
        return (JSONFactory.defaultReaderFeatures & feature.mask) != 0L;
    }

    public static void configReaderDateFormat(String dateFormat) {
        JSONFactory.defaultReaderFormat = dateFormat;
    }

    public static void configWriterDateFormat(String dateFormat) {
        JSONFactory.defaultWriterFormat = dateFormat;
    }

    public static void configReaderZoneId(ZoneId zoneId) {
        JSONFactory.defaultReaderZoneId = zoneId;
    }

    public static void configWriterZoneId(ZoneId zoneId) {
        JSONFactory.defaultWriterZoneId = zoneId;
    }

    public static void config(JSONWriter.Feature ... features) {
        for (int i = 0; i < features.length; ++i) {
            JSONFactory.defaultWriterFeatures |= features[i].mask;
        }
    }

    public static void config(JSONWriter.Feature feature, boolean state) {
        JSONFactory.defaultWriterFeatures = state ? (JSONFactory.defaultWriterFeatures |= feature.mask) : (JSONFactory.defaultWriterFeatures &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean isEnabled(JSONWriter.Feature feature) {
        return (JSONFactory.defaultWriterFeatures & feature.mask) != 0L;
    }

    public static <T> T copy(T object, JSONWriter.Feature ... features) {
        byte[] jsonbBytes;
        if (object == null) {
            return null;
        }
        Class<?> objectClass = object.getClass();
        if (ObjectWriterProvider.isPrimitiveOrEnum(objectClass)) {
            return object;
        }
        boolean fieldBased = false;
        boolean beanToArray = false;
        long featuresValue = 0L;
        for (int i = 0; i < features.length; ++i) {
            JSONWriter.Feature feature = features[i];
            featuresValue |= feature.mask;
            if (feature == JSONWriter.Feature.FieldBased) {
                fieldBased = true;
                continue;
            }
            if (feature != JSONWriter.Feature.BeanToArray) continue;
            beanToArray = true;
        }
        ObjectWriter objectWriter = JSONFactory.defaultObjectWriterProvider.getObjectWriter(objectClass, objectClass, fieldBased);
        ObjectReader objectReader = JSONFactory.defaultObjectReaderProvider.getObjectReader(objectClass, fieldBased);
        if (objectWriter instanceof ObjectWriterAdapter && objectReader instanceof ObjectReaderBean) {
            List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
            int size = fieldWriters.size();
            if (objectReader instanceof ObjectReaderNoneDefaultConstructor) {
                HashMap<String, Object> map = new HashMap<String, Object>(size, 1.0f);
                for (int i = 0; i < size; ++i) {
                    FieldWriter fieldWriter = fieldWriters.get(i);
                    Object fieldValue = fieldWriter.getFieldValue(object);
                    map.put(fieldWriter.fieldName, fieldValue);
                }
                return objectReader.createInstance(map, featuresValue);
            }
            Object instance = objectReader.createInstance(featuresValue);
            for (int i = 0; i < size; ++i) {
                FieldWriter fieldWriter = fieldWriters.get(i);
                FieldReader fieldReader = objectReader.getFieldReader(fieldWriter.fieldName);
                if (fieldReader == null) continue;
                Object fieldValue = fieldWriter.getFieldValue(object);
                Object fieldValueCopied = JSON.copy(fieldValue, new JSONWriter.Feature[0]);
                fieldReader.accept(instance, fieldValueCopied);
            }
            return instance;
        }
        try (JSONWriter writer = JSONWriter.ofJSONB(features);){
            writer.config(JSONWriter.Feature.WriteClassName);
            objectWriter.writeJSONB(writer, object, null, null, 0L);
            jsonbBytes = writer.getBytes();
        }
        try (JSONReader jsonReader = JSONReader.ofJSONB(jsonbBytes, JSONReader.Feature.SupportAutoType, JSONReader.Feature.SupportClassForName);){
            if (beanToArray) {
                jsonReader.context.config(JSONReader.Feature.SupportArrayToBean);
            }
            Object t = objectReader.readJSONBObject(jsonReader, null, null, featuresValue);
            return t;
        }
    }

    public static <T> T copyTo(Object object, Class<T> targetClass, JSONWriter.Feature ... features) {
        byte[] jsonbBytes;
        if (object == null) {
            return null;
        }
        Class<?> objectClass = object.getClass();
        boolean fieldBased = false;
        boolean beanToArray = false;
        long featuresValue = 0L;
        for (int i = 0; i < features.length; ++i) {
            JSONWriter.Feature feature = features[i];
            featuresValue |= feature.mask;
            if (feature == JSONWriter.Feature.FieldBased) {
                fieldBased = true;
                continue;
            }
            if (feature != JSONWriter.Feature.BeanToArray) continue;
            beanToArray = true;
        }
        ObjectWriter objectWriter = JSONFactory.defaultObjectWriterProvider.getObjectWriter(objectClass, objectClass, fieldBased);
        ObjectReader objectReader = JSONFactory.defaultObjectReaderProvider.getObjectReader(targetClass, fieldBased);
        if (objectWriter instanceof ObjectWriterAdapter && objectReader instanceof ObjectReaderBean) {
            List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
            if (objectReader instanceof ObjectReaderNoneDefaultConstructor) {
                HashMap<String, Object> map = new HashMap<String, Object>(fieldWriters.size(), 1.0f);
                for (int i = 0; i < fieldWriters.size(); ++i) {
                    FieldWriter fieldWriter = fieldWriters.get(i);
                    Object fieldValue = fieldWriter.getFieldValue(object);
                    map.put(fieldWriter.fieldName, fieldValue);
                }
                return objectReader.createInstance(map, featuresValue);
            }
            Object instance = objectReader.createInstance(featuresValue);
            for (int i = 0; i < fieldWriters.size(); ++i) {
                FieldWriter fieldWriter = fieldWriters.get(i);
                FieldReader fieldReader = objectReader.getFieldReader(fieldWriter.fieldName);
                if (fieldReader == null) continue;
                Object fieldValue = fieldWriter.getFieldValue(object);
                Object fieldValueCopied = fieldWriter.fieldClass == Date.class && fieldReader.fieldClass == String.class ? DateUtils.format((Date)fieldValue, fieldWriter.format) : (fieldWriter.fieldClass == LocalDate.class && fieldReader.fieldClass == String.class ? DateUtils.format((LocalDate)fieldValue, fieldWriter.format) : (fieldValue == null || fieldReader.supportAcceptType(fieldValue.getClass()) ? fieldValue : JSON.copy(fieldValue, new JSONWriter.Feature[0])));
                fieldReader.accept(instance, fieldValueCopied);
            }
            return instance;
        }
        try (JSONWriter writer = JSONWriter.ofJSONB(features);){
            writer.config(JSONWriter.Feature.WriteClassName);
            objectWriter.writeJSONB(writer, object, null, null, 0L);
            jsonbBytes = writer.getBytes();
        }
        try (JSONReader jsonReader = JSONReader.ofJSONB(jsonbBytes, JSONReader.Feature.SupportAutoType, JSONReader.Feature.SupportClassForName);){
            if (beanToArray) {
                jsonReader.context.config(JSONReader.Feature.SupportArrayToBean);
            }
            Object t = objectReader.readJSONBObject(jsonReader, null, null, 0L);
            return t;
        }
    }
}

